#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/user/User.as"
#include "petmarket/service/user/GetUser.as"

if (test.petmarket.service.user.GetUserTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.user.GetUserTest",
		seasar.unit.TestCase, ["user", "service"]);
	
	var proto = test.petmarket.service.user.GetUserTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.user = new petmarket.service.user.User(conn);
		this.service = new petmarket.service.user.GetUser(conn, this.user);
	}
	
	proto.tearDown = function() {
		this.user = null;
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.user = this.user;
		listener.getUserPerformed = function(data) {
			trace("listener.getUserPerformed:" + data.useroid);
			trace("listener.user.userData:" + this.user.userData.useroid);
		}
		seasar.event.Broadcaster.addEventListener("getUser", listener);
		this.service.execute("higa@isid.co.jp", "yasuo");
	}

	delete proto;
}