#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/user/User.as"

if (test.petmarket.service.user.UserTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.user.UserTest",
		seasar.unit.TestCase, ["user"]);
	
	var proto = test.petmarket.service.user.UserTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.user = new petmarket.service.user.User(conn);
	}
	
	proto.tearDown = function() {
		this.user = null;
	}
/*	
	proto.testAddUser = function() {
		var listener = new Object();
		listener.user = this.user;
		listener.addUserPerformed = function(data) {
			trace("listener.addUserPerformed:" + data);
			trace("listener.user.userData:" + this.user.userData);
		}
		seasar.event.Broadcaster.addEventListener("addUser", listener);
		this.user.addUser("hoge", "hoge");
	}
*/
	
	proto.testGetUser = function() {
		var listener = new Object();
		listener.user = this.user;
		listener.getUserPerformed = function(data) {
			trace("listener.getUserPerformed:" + data.email);
			trace("listener.user.userData:" + this.user.userData.email);
		}
		seasar.event.Broadcaster.addEventListener("getUser", listener);
		this.user.getUser("higa@isid.co.jp", "yasuo");
	}
	
	proto.testUpdateUser = function() {
		var listener = new Object();
		listener.updateUserPerformed = function(data) {
			trace("listener.updateUserPerformed");
		}
		seasar.event.Broadcaster.addEventListener("updateUser", listener);
		this.user.userData = new Object();
		this.user.userData.useroid = "0";
		this.user.userData.email = "seasar";
		this.user.updateUser();
	}
	
	delete proto;
}