package org.seasar.extension.dataset.impl;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.TableNotFoundRuntimeException;
import org.seasar.framework.util.ArrayMap;

/**
 * @author higa
 *
 */
public class DataSetImpl implements DataSet {

	private ArrayMap tables_ = new ArrayMap();
	
	public DataSetImpl() {
	}

	/**
	 * @see org.seasar.extension.dataset.DataSet#getTableSize()
	 */
	public int getTableSize() {
		return tables_.size();
	}	

	/**
	 * @see org.seasar.extension.dataset.DataSet#getTable(int)
	 */
	public DataTable getTable(int index) {
		return (DataTable) tables_.get(index);
	}

	/**
	 * @see org.seasar.extension.dataset.DataSet#getTable(java.lang.String)
	 */
	public DataTable getTable(String tableName)
		throws TableNotFoundRuntimeException {

		DataTable table = (DataTable) tables_.get(tableName);
		if (table == null) {
			throw new TableNotFoundRuntimeException(tableName);
		}
		return table;
	}

	/**
	 * @see org.seasar.extension.dataset.DataSet#addTable(org.seasar.extension.dataset.DataTable)
	 */
	public void addTable(DataTable table) {
		tables_.put(table.getTableName(), table);
	}

}
