package org.seasar.framework.container.assembler;

import java.lang.reflect.Method;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalMethodRuntimeException;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.util.AutoBindingUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.parser.SelParser;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *
 */
public abstract class AbstractMethodAssembler
	extends AbstractAssembler
	implements MethodAssembler {

	public AbstractMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}
	
	protected void invoke(
		BeanDesc beanDesc,
		Object component,
		MethodDef methodDef)
		throws IllegalMethodRuntimeException {

		String expression = methodDef.getExpression(); 
		if (expression != null) {
			invokeExpression(component, expression);
		} else {
			Object[] args = null;
			Method method = null;
			try {
				if (methodDef.getArgDefSize() > 0) {
					args = methodDef.getArgs();
				} else {
					Method[] methods = beanDesc.getMethods(methodDef.getMethodName());
					method = getSuitableMethod(methods);
					if (method != null) {
						args = getArgs(method.getParameterTypes());
					}
				}
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalMethodRuntimeException(
					getComponentClass(component),
					methodDef.getMethodName(),
					cause);
			}
			if (method != null) {
				MethodUtil.invoke(method, component, args);
			} else {
				invoke(beanDesc, component, methodDef.getMethodName(), args);
			}
		}
	}
	
	private void invokeExpression(Object component, String expression) {
		SelContext ctx = getComponentDef().getContainer().getSelContext();
		Expression exp = new SelParser(expression).parseExpression();
		ctx.setVariable("this", component);
		try {
			exp.evaluateValue(ctx);
		} finally {
			ctx.setVariable("this", null);
		}
	}
	
	private Method getSuitableMethod(Method[] methods) {
		int argSize = -1;
		Method method = null;
		for (int i = 0; i < methods.length; ++i) {
			int tempArgSize = methods[i].getParameterTypes().length;
			if (tempArgSize > argSize
				&& AutoBindingUtil.isSuitable(
					methods[i].getParameterTypes())) {
				method = methods[i];
				argSize = tempArgSize;
			}
		}
		return method;
	}

	private void invoke(
		BeanDesc beanDesc,
		Object component,
		String methodName,
		Object[] args)
		throws IllegalMethodRuntimeException {

		try {
			beanDesc.invoke(component, methodName, args);
		} catch (NumberFormatException ex) {
			throw new IllegalMethodRuntimeException(
				getComponentDef().getComponentClass(),
				methodName,
				ex);
		}
	}
}
