package org.seasar.framework.sel;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * \zÕg[NƂ̎sO
 */
public class UnexpectedTokenRuntimeException extends SRuntimeException {

	private String readString_;
	private String expectedTokenName_;
	private String unexpectedTokenName_;
	private String realTokenName_;
	
	public UnexpectedTokenRuntimeException(
		String readString,
		String expectedTokenName,
		String realTokenName) {

		super(
			"ESSR0002",
			new Object[] { readString, expectedTokenName, realTokenName });
		readString_ = readString;
		expectedTokenName_ = expectedTokenName;
		realTokenName_ = realTokenName;
	}
	
	public UnexpectedTokenRuntimeException(
		String readString,
		String unexpectedTokenName) {

		super(
			"ESSR0003",
			new Object[] { readString, unexpectedTokenName });
		readString_ = readString;
		unexpectedTokenName_ = unexpectedTokenName;
	}
	
	public String getReadString() {
		return readString_;
	}
	
	public String getExpectedTokenName() {
		return expectedTokenName_;
	}
	
	public String getRealTokenName() {
		return realTokenName_;
	}
	
	public String getUnexpectedTokenName() {
		return unexpectedTokenName_;
	}
}