package org.seasar.framework.sel.exps;

import java.lang.reflect.Array;
import java.util.List;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class GetArrayExp implements Expression {

	private Expression targetExp_;
	private Expression indexExp_;
	
    public GetArrayExp(Expression targetExp, Expression indexExp) {
		targetExp_ = targetExp;
        indexExp_ = indexExp;
    }

    public Object evaluateValue(SelContext context) {
		Number indexNum = (Number) indexExp_.evaluateValue(context);
		int index = indexNum.intValue();
		Object target = targetExp_.evaluateValue(context);
		if (target instanceof List) {
			return ((List) target).get(index);
		} else {
			return Array.get(target, index);
		}
    }
}
