package test.org.seasar.framework.aop.impl;

import java.lang.reflect.Method;

import junit.framework.TestCase;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Joinpoint;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.util.ClassUtil;

/**
 * @author higa
 *
 */
public class PointcutImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public PointcutImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(PointcutImplTest.class);
	}

	public void testGetMethodNames() throws Exception {
		PointcutImpl pointcut = new PointcutImpl(Hello2Impl.class);
		String[] methodNames = pointcut.getMethodNames();
		assertEquals("1", 2, methodNames.length);
		for (int i = 0; i < methodNames.length; ++i) {
			System.out.println(methodNames[i]);
		}
	}

	public void testRegex() throws Exception {
		PointcutImpl pointcut = new PointcutImpl(new String[] { "greeting.*" });
		Method m = ClassUtil.getMethod(Hello2Impl.class, "greeting", null);
		assertEquals("1", true, pointcut.isApplied(m));
		m = ClassUtil.getMethod(Hello2Impl.class, "greeting2", null);
		assertEquals("2", true, pointcut.isApplied(m));
		m = ClassUtil.getMethod(getClass(), "testRegex", null);
		assertEquals("3", false, pointcut.isApplied(m));
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public class TestAdvice implements AroundAdvice {

		private boolean invoked_ = false;

		public Object invoke(Joinpoint joinpoint) throws Throwable {
			invoked_ = true;
			return joinpoint.proceed();
		}

	}

	public interface Hello {
		public String greeting();
	}

	public static class HelloImpl implements Hello {

		public String greeting() {
			return "Hello";
		}
	}

	public class HelloAdvice implements AroundAdvice {
		public Object invoke(Joinpoint joinpoint) throws Throwable {
			return "Hello";
		}
	}

	public interface Hello2 extends Hello {
		public String greeting2();
	}

	public static class Hello2Impl extends HelloImpl implements Hello2 {

		public String greeting2() {
			return "Hello2";
		}
	}
}