package examples.hibernate.client;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

import examples.hibernate.service.EmployeeService;

public class EmployeeClient {

	private static final String PATH =
		"examples/hibernate/client/Employee-config.xml";

	public static void main(String[] args) {
		S2Container container = S2ContainerFactory.create(PATH);
		container.init();
		try {
			EmployeeService service =
				(EmployeeService) container.getComponent(EmployeeService.class);
			System.out.println(service.getEmployee(7788).getEname());
		} finally {
			container.destroy();
		}

	}
}
