package examples.hibernate.dao;

import java.util.List;

import net.sf.hibernate.Hibernate;

import org.seasar.hibernate.S2SessionFactory;

import examples.hibernate.entity.Employee;

public class EmployeeDaoImpl implements EmployeeDao {

	private static final String HQL = "from Employee where empno = ?";
	private S2SessionFactory sessionFactory_;

	public EmployeeDaoImpl(S2SessionFactory sessionFactory) {
		sessionFactory_ = sessionFactory;
	}

	public Employee getEmployee(int empno) {
		List result = sessionFactory_.getSession().find(
			HQL, new Integer(empno), Hibernate.INTEGER);
		if (result.size() > 0) {
			return (Employee) result.get(0);
		} else {
			return null;
		}
	}
}
