package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public class BetweenExp implements BoolExpression {

	private final Expression arg1Exp_;
	private final Expression fromExp_;
	private final Expression toExp_;

	public BetweenExp(
		Expression arg1Exp,
		Expression fromExp,
		Expression toExp) {

		arg1Exp_ = arg1Exp;
		fromExp_ = fromExp;
		toExp_ = toExp;
	}

	public boolean evaluate(SelContext context) {
		Comparable arg1 = getArg1(context);
		Comparable from = getFrom(context);
		Comparable to = getTo(context);
		if (arg1 == null || from == null || to == null) {
			return false;
		} else {
			return arg1.compareTo(from) >= 0 && arg1.compareTo(to) <= 0;
		}
	}
	
	protected Comparable getArg1(SelContext context) {
		return (Comparable) arg1Exp_.evaluateValue(context);
	}
	
	protected Comparable getFrom(SelContext context) {
		return (Comparable) fromExp_.evaluateValue(context);
	}
	
	protected Comparable getTo(SelContext context) {
		return (Comparable) toExp_.evaluateValue(context);
	}
}