package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class LessThanExp extends AbstractCompareExp {

	public LessThanExp(Expression arg1Exp, Expression arg2Exp) {
		super(arg1Exp, arg2Exp);
	}

	public boolean evaluate(SelContext context) {
		Comparable arg1 = getArg1(context);
		Comparable arg2 = getArg2(context);
		if (arg1 == null || arg2 == null) {
			return false;
		} else {
			return arg1.compareTo(arg2) < 0;
		}
	}
}
