package org.seasar.extension.dataset.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.RowHandler;

public class DataRowHandler implements RowHandler {

	private DataTable table_;
	
	public DataRowHandler(DataTable table) {
		table_ = table;
	}
	
	public DataTable getTable() {
		return table_;
	}

	public Object createRowValue(ResultSet rs, PropertyType[] propertyTypes)
		throws SQLException {

		DataRow row = table_.addRow();
		for (int i = 0; i < propertyTypes.length; ++i) {
			Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
			row.setValue(propertyTypes[i].getPropertyName(), value);
		}
		row.setState(RowStates.UNCHANGED);
		return row;
	}
}