package org.seasar.extension.dataset.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.impl.AbstractResultSetHandler;

public class DataTableResultSetHandler extends AbstractResultSetHandler {

	private String tableName_;

	public DataTableResultSetHandler(String tableName) {
		tableName_ = tableName;
		setPropertyHandler(new DataColumnPropertyHandler());
	}

	public String getTableName() {
		return tableName_;
	}

	public Object handle(ResultSet rs, DatabaseMetaData dbMetaData)
		throws SQLException {

		ResultSetMetaData rsmd = rs.getMetaData();
		PropertyType[] propertyTypes =
			getPropertyHandler().createPropertyTypes(rsmd);
		DataTable table = new DataTableImpl(tableName_);
		for (int i = 0; i < propertyTypes.length; ++i) {
			String propertyName = propertyTypes[i].getPropertyName();
			DataColumn column = table.addColumn(propertyName,
				ColumnTypes.getColumnType(rsmd.getColumnType(i + 1)));
		}
		table.setupMetaData(dbMetaData);
		setRowHandler(new DataRowHandler(table));
		while (rs.next()) {
			getRowHandler().createRowValue(rs, propertyTypes);
		}
		return table;
	}
}
