package org.seasar.extension.jdbc.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.jdbc.PropertyType;

public class SingleRowResultSetHandler extends AbstractResultSetHandler {

	public SingleRowResultSetHandler() {
	}

	public Object handle(ResultSet rs, DatabaseMetaData dbMetaData)
		throws SQLException {

		ResultSetMetaData rsmd = rs.getMetaData();
		if (rs.next()) {
			PropertyType[] propertyTypes =
				getPropertyHandler().createPropertyTypes(rsmd);
			return getRowHandler().createRowValue(rs, propertyTypes);
		} else {
			return null;
		}
	}
}
