package org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.SelContext;

/**
 * @author higa
 *
 */
public class S2ContainerImpl implements S2Container, ContainerConstants {

	private Map componentDefMap_ = new HashMap();
	private List componentDefList_ = new ArrayList();
	private SelContext selContext_ = new S2ContainerSelContext(this);
	private String namespace_;
	private S2Container rootContainer_;
	private List children_ = new ArrayList();

	public S2ContainerImpl() {
		ComponentDef selfDef = new SimpleComponentDef(this, NAME);
		registerMap(NAME, selfDef);
		registerMap(S2Container.class, selfDef);
		componentDefMap_.put("out", new SimpleComponentDef(System.out, "out"));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(Object componentKey) {
		return getComponentDef(componentKey).getComponent();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object)
	 */
	public void injectDependency(Object outerComponent) {
		injectDependency(outerComponent, outerComponent.getClass());
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object, java.lang.Class)
	 */
	public void injectDependency(Object outerComponent, Class componentClass) {
		getComponentDef(componentClass).injectDependency(outerComponent);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object, java.lang.String)
	 */
	public void injectDependency(Object outerComponent, String componentName) {
		getComponentDef(componentName).injectDependency(outerComponent);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object)
	 */
	public void register(Object component) {
		register(new SimpleComponentDef(component));
	}

	public void register(Object component, String componentName) {
		register(new SimpleComponentDef(component, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		register(new ComponentDefImpl(componentClass));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class, java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		register(new ComponentDefImpl(componentClass, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		register0(componentDef);
		componentDefList_.add(componentDef);
	}

	private void register0(ComponentDef componentDef) {
		if (componentDef.getContainer() == null) {
			componentDef.setContainer(this);
		}
		Class[] classes =
			getAssignableClasses(componentDef.getComponentClass());
		for (int i = 0; i < classes.length; ++i) {
			registerMap(classes[i], componentDef);
		}
		String componentName = componentDef.getComponentName();
		if (componentName != null) {
			registerMap(componentName, componentDef);
			String ns = componentDef.getContainer().getNamespace();
			if (ns != null) {
				registerMap(ns + NS_SEP + componentName, componentDef);
			}
		}
	}

	private void registerMap(Object key, ComponentDef componentDef) {
		if (componentDefMap_.containsKey(key)) {
			processTooManyRegistration(key, componentDef);
		} else {
			componentDefMap_.put(key, componentDef);
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDefSize()
	 */
	public int getComponentDefSize() {
		return componentDefList_.size();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(int)
	 */
	public ComponentDef getComponentDef(int index) {
		return (ComponentDef) componentDefList_.get(index);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(Object key)
		throws ComponentNotFoundRuntimeException {

		ComponentDef cd = getComponentDef0(key);
		if (cd == null) {
			throw new ComponentNotFoundRuntimeException(key);
		}
		return cd;
	}

	private ComponentDef getComponentDef0(Object key) {
		ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
		if (cd == null
			&& rootContainer_ != null
			&& rootContainer_.hasComponentDef(key)) {

			cd = rootContainer_.getComponentDef(key);
		}
		return cd;
	}

	public boolean hasComponentDef(Object componentKey) {
		ComponentDef componentDef = getComponentDef0(componentKey);
		return componentDef != null
			&& !(componentDef instanceof TooManyRegistrationComponentDef);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#include(org.seasar.framework.container.S2Container)
	 */
	public void include(S2Container child) {
		if (rootContainer_ != null) {
			child.setRootContainer(rootContainer_);
		} else {
			child.setRootContainer(this);
		}
		children_.add(child);
		for (int i = 0; i < child.getComponentDefSize(); ++i) {
			register(child.getComponentDef(i));
		}

	}

	/**
	 * @see org.seasar.framework.container.S2Container#getSelContext()
	 */
	public SelContext getSelContext() {
		return selContext_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#init()
	 */
	public void init() {
		for (int i = 0; i < getComponentDefSize(); ++i) {
			getComponentDef(i).init();
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#destroy()
	 */
	public void destroy() {
		for (int i = getComponentDefSize() - 1; 0 <= i; --i) {
			try {
				getComponentDef(i).destroy();
			} catch (Throwable t) {
				t.printStackTrace();
			}

		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getNamespace()
	 */
	public String getNamespace() {
		return namespace_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#setNamespace(java.lang.String)
	 */
	public void setNamespace(String namespace) {
		namespace_ = namespace;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getRootContainer()
	 */
	public S2Container getRootContainer() {
		return rootContainer_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#setRootContainer(org.seasar.framework.container.S2Container)
	 */
	public void setRootContainer(S2Container rootContainer) {
		rootContainer_ = rootContainer;
		for (int i = 0; i < children_.size(); ++i) {
			S2Container child = (S2Container) children_.get(i);
			child.setRootContainer(rootContainer);
		}
	}

	private static Class[] getAssignableClasses(Class componentClass) {
		Set classes = new HashSet();
		for (Class clazz = componentClass;
			clazz != Object.class && clazz != null;
			clazz = clazz.getSuperclass()) {
			classes.add(clazz);
			Class[] interfaces = clazz.getInterfaces();
			for (int i = 0; i < interfaces.length; ++i) {
				classes.add(interfaces[i]);
			}
		}
		return (Class[]) classes.toArray(new Class[classes.size()]);
	}

	private void processTooManyRegistration(
		Object key,
		ComponentDef componentDef) {

		ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
		if (cd instanceof TooManyRegistrationComponentDef) {
			((TooManyRegistrationComponentDef) cd).addComponentClass(
				componentDef.getComponentClass());
		} else {
			TooManyRegistrationComponentDef tmrcf =
				new TooManyRegistrationComponentDef(key);
			tmrcf.addComponentClass(cd.getComponentClass());
			tmrcf.addComponentClass(componentDef.getComponentClass());
			componentDefMap_.put(key, tmrcf);
		}
	}
}
