package org.seasar.framework.sel.exps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class BooleanExp implements Expression {

	public static final BooleanExp TRUE = new BooleanExp(true);
	public static final BooleanExp FALSE = new BooleanExp(false);
	private final boolean value_;

	private BooleanExp(boolean value) {
		value_ = value;
	}

	public Object evaluateValue(SelContext context) {
		return value_ ? Boolean.TRUE : Boolean.FALSE;
	}
}