package test.examples.unit;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataTableImpl;
import org.seasar.extension.unit.S2TestCase;

import examples.unit.Employee;
import examples.unit.EmployeeDao;

public class EmployeeDaoImplTest extends S2TestCase {

	private EmployeeDao dao_;

	public EmployeeDaoImplTest(String arg0) {
		super(arg0);
	}

	public void setUp() {
		include("j2ee-config.xml");
		include("examples/unit/EmployeeDao-config.xml");
	}

	public void testGetEmployeeTx() throws Exception {
		readXlsWriteDb("getEmployeePrepare.xls");
		Employee emp = dao_.getEmployee(9900);
		DataTable table = new DataTableImpl("emp");
		table.setupColumns(Employee.class);
		table.copyFrom(emp);
		DataSet dataSet = readXls("getEmployeeResult.xls");
		assertEquals("1", dataSet.getTable("emp"), table);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(EmployeeDaoImplTest.class);
	}
}