package test.org.seasar.framework.container.assembler;

import junit.framework.TestCase;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.TraceInterceptor;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AutoConstructorAssembler;
import org.seasar.framework.container.assembler.ConstructorAssembler;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.NoSuchConstructorRuntimeException;

/**
 * @author higa
 *
 */
public class AutoConstructorAssemblerTest extends TestCase {

	public AutoConstructorAssemblerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AutoConstructorAssemblerTest.class);
	}

	public void testAssemble() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		container.register(B.class);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", "B", a.getHogeName());
	}

	public void testAssembleAspect() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		cd.addAspectDef(new AspectDefImpl(new TraceInterceptor()));
		container.register(cd);
		container.register(B.class);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", "B", a.getHogeName());
	}

	public void testAssembleArgNotFound() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", null, a.getHoge());
	}

	public void testAssembleDefaultConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(String.class);
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		assertEquals("1", "", assembler.assemble());
	}
	
	public void testAssembleDefaultConstructor2() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(Hoge.class);
		cd.addAspectDef(new AspectDefImpl(new HogeInterceptor()));
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		Hoge hoge = (Hoge) assembler.assemble();
		assertEquals("1", "hoge", hoge.getName());
	}

	public void testAssembleAutoNotInterfaceConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(C.class);
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		try {
			assembler.assemble();
			fail("1");
		} catch (NoSuchConstructorRuntimeException ex) {
			System.out.println(ex);
		}
		
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public interface Foo {
		public String getHogeName();
	}

	public static class A implements Foo {

		private Hoge hoge_;

		public A(Hoge hoge) {
			hoge_ = hoge;
		}

		public Hoge getHoge() {
			return hoge_;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}

	public static class C {

		private String name_;

		public C(String name) {
			name_ = name;
		}

		public String getName() {
			return name_;
		}
	}
	
	public class HogeInterceptor implements MethodInterceptor {
		public Object invoke(MethodInvocation invocation) throws Throwable {
			return "hoge";
		}
	}
}