package test.org.seasar.framework.sel.exps;

import java.math.BigDecimal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.NewExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.util.ExpressionUtil;

public class NewExpTest extends TestCase {

	public NewExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		Expression exp =
			new NewExp(
				BigDecimal.class,
				new Expression[] { new ObjectExp("1")});
		assertEquals("1", new BigDecimal("1"), exp.evaluateValue(null));
	}

	public void testEvaluateValue2() throws Exception {
		Expression exp =
			new NewExp(Object.class, ExpressionUtil.EMPTY_EXPRESSIONS);
		assertNotNull("1", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(NewExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { NewExpTest.class.getName()});
	}
}