/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 * shintaro.fujiwara@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h>
#include <qwidgetlist.h>

class QAction;
class QLabel;
class QWorkspace;
class QSplitter;
class QTextEdit;
class QPushButton;
class Editor;
class ParseLines;
class ParseLinesAdmin;
class ParseLinesApps;
class ParseLinesKernel;
class ParseLinesServices;
class ParseLinesSystem;
class ParseLinesMisc;
class ParseLinesSelpaw;
class Selpaw;
class SelpawAdjust;
class SegatexState;
class SegatexApply;
class SegatexSetenforce;
class SegatexYum;
class SegatexYumProcess;
class SegatexAudit2allow;
class SegatexCore;
class SemoduleCoreProcess;
class SemanageCoreProcess;
class SemanageCoreLoginProcess;
class SemanageCoreFcontextProcess;
class SemanageCorePortProcess;

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0, const char *name = 0);

public slots:
    void newFile();
    void openFile(const QString &fileName);
    void updateSegatexStateIndicator();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void open();

    //newly added
    void open_interfaces_admin_txt();
    void open_interfaces_apps_txt();
    void open_interfaces_kernel_txt();
    void open_interfaces_services_txt();
    void open_interfaces_system_txt();
    void open_obj_perm_sets_prepare_txt();
    void open_ipc_patterns_prepare_txt();
    void open_misc_patterns_prepare_txt();
    void open_interfaces_admin_broken_up_txt();
    void open_interfaces_apps_broken_up_txt();
    void open_interfaces_kernel_broken_up_txt();
    void open_interfaces_services_broken_up_txt();
    void open_interfaces_system_broken_up_txt();
    void open_selpaw_admin_txt();
    void open_selpaw_apps_txt();
    void open_selpaw_kernel_txt();
    void open_selpaw_services_txt();
    void open_selpaw_system_txt();
    void open_selpaw_interface_raw_csv();
    void open_selpaw_eliminated_interfaces_csv();
    void open_selpaw_interface_ready_csv();
    void open_selpaw_interface_csv();
    void howtouse();
    void enforcing();
    void yum_selinux();
    void yum_selinux_process();
    void audit2allow();
    void segatex_core();
    void semodule_core_process();
    void semanage_core_process();
    void semanage_core_login_process();
    void semanage_core_fcontext_process();
    void semanage_core_port_process();

    void save();
    void saveAs();
    void cut();
    void copy();
    void paste();
    void del();
    void about();
    void notice();

    void updateMenus();
    void activateWindow(int param);
    void copyAvailable(bool available);
    void updateModIndicator();

private:
    void createActions();
    void createMenus();
    void createWindowsMenu();
    void createToolBars();
    void createStatusBar();
    bool modified;

    Editor *createEditor();
    Editor *activeEditor();

    QWorkspace *workspace;
    QLabel *readyLabel;
    QLabel *modLabel;
    QLabel *segatexStateLabel;
    QWidgetList windows;

    //newly added
    QSplitter *topSplitter;
    QSplitter *horizontalSplitter;
    QTextEdit *textEcho;
    QString selinux_policy;
    QString enabled_or_not_str;
    QString getenforce_str;
    
    ParseLines *parse1;
    ParseLines *parse2;
    ParseLines *parse3;
    ParseLines *parse4;
    ParseLines *parse5;
    ParseLines *parse6;
    ParseLines *parse9;
    ParseLines *parse10;
    ParseLines *parse11;
    ParseLines *parse12;    
    ParseLines *parse13;        
    ParseLines *parse14;
    Selpaw *selpaw1;
    SelpawAdjust *selpawadjust1;
    SegatexState *segatex_state;
    SegatexApply *segatex_apply;
    SegatexSetenforce *segatex_apply_for_state;
    SegatexYum *selinux_yum;
    SegatexYumProcess *selinux_yum_process;
    SegatexAudit2allow *selinux_audit2allow;
    SegatexCore *segatex_core_o;
    SemoduleCoreProcess *semodule_core_process_o;
    SemanageCoreProcess *semanage_core_process_o;
    SemanageCoreLoginProcess *semanage_core_login_process_o;
    SemanageCoreFcontextProcess *semanage_core_fcontext_process_o;
    SemanageCorePortProcess *semanage_core_port_process_o;
    
    QPopupMenu *fileMenu;
    QPopupMenu *editMenu;
    QPopupMenu *windowsMenu;
    QPopupMenu *helpMenu;
    //newly added
    QPopupMenu *parselinesMenu;
    QPopupMenu *selpawMenu;
    QPopupMenu *refineMenu;
    QPopupMenu *policyMenu;
    QPopupMenu *manageMenu;
    QPopupMenu *semanageMenu;

    QToolBar *fileToolBar;
    QToolBar *editToolBar;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *saveAsAct;
    QAction *exitAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *deleteAct;
    QAction *closeAct;
    QAction *closeAllAct;
    QAction *tileAct;
    QAction *cascadeAct;
    QAction *nextAct;
    QAction *previousAct;
    QAction *aboutAct;
    QAction *aboutQtAct;
    //newly added
    QAction *parse_adminAct;
    QAction *parse_appsAct;
    QAction *parse_kernelAct;
    QAction *parse_servicesAct;
    QAction *parse_systemAct;
    QAction *obj_perm_setsAct;
    QAction *ipc_patternsAct;
    QAction *misc_patternsAct;
    QAction *break_adminAct;
    QAction *break_appsAct;
    QAction *break_kernelAct;
    QAction *break_servicesAct;
    QAction *break_systemAct;
    QAction *selpaw_adminAct;
    QAction *selpaw_appsAct;
    QAction *selpaw_kernelAct;
    QAction *selpaw_servicesAct;
    QAction *selpaw_systemAct;
    QAction *selpaw_interface_rawAct;
    QAction *selpaw_eliminated_interfacesAct;
    QAction *selpaw_interface_readyAct;
    QAction *selpaw_interface_csvAct;
    QAction *howtouseAct;
    QAction *enforcingAct;
    QAction *check_selinuxAct;
    QAction *default_policyAct;
    QAction *selinuxYumAct;
    QAction *selinuxYumProcessAct;
    QAction *audit2allowAct;
    QAction *segatex_coreAct;
    QAction *semodule_core_processAct;
    QAction *semanage_core_processAct;
    QAction *semanage_core_login_processAct;
    QAction *semanage_core_fcontext_processAct;
    QAction *semanage_core_port_processAct;
};

#endif
