/********************************************
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
 ** Contact: Qt Software Information (qt-info@nokia.com)
 **
 ** This file is part of the example classes of the Qt Toolkit.
 **
 ** Commercial Usage
 ** Licensees holding valid Qt Commercial licenses may use this file in
 ** accordance with the Qt Commercial License Agreement provided with the
 ** Software or, alternatively, in accordance with the terms contained in
 ** a written agreement between you and Nokia.
 **
 **
 ** GNU General Public License Usage
 ** Alternatively, this file may be used under the terms of the GNU
 ** General Public License versions 2.0 or 3.0 as published by the Free
 ** Software Foundation and appearing in the file LICENSE.GPL included in
 ** the packaging of this file.  Please review the following information
 ** to ensure GNU General Public Licensing requirements will be met:
 ** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
 ** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
 ** exception, Nokia gives you certain additional rights. These rights
 ** are described in the Nokia Qt GPL Exception version 1.3, included in
 ** the file GPL_EXCEPTION.txt in this package.
 **
 ** Qt for Windows(R) Licensees
 ** As a special exception, Nokia, as the sole copyright holder for Qt
 ** Designer, grants users of the Qt/Eclipse Integration plug-in the
 ** right for the Qt/Eclipse Integration to link to functionality
 ** provided by Qt Designer and its related libraries.
 **
 ** If you are unsure which license is appropriate for your use, please
 ** contact the sales department at qt-sales@nokia.com.
 **
 ****************************************************************************/
#include <QtGui>

#include <qaction.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qworkspace.h>
//newly added
#include <qsplitter.h>
#include <qpushbutton.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <QPixmap>
#include <Q3PopupMenu>
#include <QCloseEvent>

#include "editor.h"

#include "mainwindow.h"
#include "mdichild.h"
#include "breakte.h"
#include "breakif.h"
#include "segatex_state.h"
#include "segatex_apply.h"
#include "segatex_setenforce.h"
#include "segatex_yum.h"
#include "segatex_yum_process.h"
#include "segatex_audit2allow.h"
#include "segatex_core.h"
#include "semodule_core_process.h"
#include "semanage_core_process.h"
#include "semanage_core_login_process.h"
#include "semanage_core_fcontext_process.h"
#include "semanage_core_port_process.h"
#include "semanage_core_translation_process.h"
#include "semanage_core_boolean_process.h"
#include "semanage_core_permissive_process.h"
#include "seinfo.h"
#include "autorelabel.h"
#include "policygeneration.h"
#include "aureport.h"
#include "ausearch.h"
#include "useradd.h"
#include "seeprocess.h"
#include "restorecon.h"
#include "mainwindow.h"
#include "downloader.h"
#include "sqlrefpolicy.h"
#include "semodule_dontaudit.h"
#include "segatex_getseuserbyname.h"

 MainWindow::MainWindow()
{
	mdiArea = new QMdiArea;
	mdiArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
	mdiArea->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
	setCentralWidget(mdiArea);
	connect(mdiArea, SIGNAL(subWindowActivated(QMdiSubWindow *)),
		this, SLOT(updateMenus()));
	windowMapper = new QSignalMapper(this);
	connect(windowMapper, SIGNAL(mapped(QWidget *)),
		this, SLOT(setActiveSubWindow(QWidget *)));
	connect(windowMapper, SIGNAL(mapped(QWidget *)),
		this, SLOT(updateModIndicator()));
	connect(windowMapper, SIGNAL(mapped(QWidget *)),
		this, SLOT(updateSegatexStateIndicator()));

	breakte = new BreakTe();
	breakif = new BreakIf();
	segatex_state = new SegatexState();
	//needs here to be declared when opening a new window unless segmentation fualt happens...

	breakte_o = 0;
	breakif_o = 0;
	segatex_apply = 0;
	selinux_yum = 0;
	selinux_yum_process = 0;
	selinux_audit2allow = 0;
	segatex_core_o = 0;
	semodule_core_process_o = 0;
	semanage_core_process_o = 0;
	semanage_core_login_process_o = 0;
	semanage_core_fcontext_process_o = 0;
	semanage_core_port_process_o = 0;
	semanage_core_translation_process_o = 0;
	semanage_core_boolean_process_o = 0;
	semanage_core_permissive_process_o = 0;
	seinfo_o = 0;
	autorelabel_process_o = 0;
	policygeneration_process_o = 0;
	aureport_o = 0;
	ausearch_o = 0;
	useradd_o = 0;
	seeprocess_o = 0;
	restorecon_o = 0;
	downloader_o = 0;
	sqlrefpolicy_o = 0;
	semodule_dontaudit_o = 0;
	segatex_getseuserbyname_o = 0;

	//semodule_dontaudit_o = new SemoduleDontaudit(this);
	//semodule_dontaudit_o->semodule_dontaudit_base_process();

	createActions();
	createMenus();
	createToolBars();
	createStatusBar();
	updateMenus();
	readSettings();
	setWindowTitle(tr("segatex-7.780"));
	QPixmap myIcon1 = QPixmap(":/images/icon.png");
	this->setIcon(myIcon1);
	//for test
	//audit2allow();
}
void MainWindow::createMenus()
{
	fileMenu = menuBar()->addMenu(tr("&File"));
	fileMenu->addAction(newAct);
	fileMenu->addAction(openAct);
	fileMenu->addAction(saveAct);
	fileMenu->addAction(saveAsAct);
	fileMenu->addSeparator();
	QAction *action = fileMenu->addAction(tr("Switch layout direction"));
	connect(action, SIGNAL(triggered()), this, SLOT(switchLayoutDirection()));
	fileMenu->addAction(exitAct);

	editMenu = menuBar()->addMenu(tr("&Edit"));
	editMenu->addAction(cutAct);
	editMenu->addAction(copyAct);
	editMenu->addAction(pasteAct);

	windowMenu = menuBar()->addMenu(tr("&Window"));
	updateWindowMenu();
	connect(windowMenu, SIGNAL(aboutToShow()), this, SLOT(updateWindowMenu()));
	menuBar()->addSeparator();

	auditMenu = menuBar()->addMenu(tr("&Audit"));
	auditMenu->addAction(semodule_dontauditAct);
	auditMenu->addAction(segatex_coreAct);
	auditMenu->addAction(audit2allowAct);
	auditMenu->addAction(aureportAct);
	auditMenu->addAction(ausearchAct);

	policyMenu = menuBar()->addMenu(tr("&Policy"));
	policyMenu->addAction(sqlrefpolicyAct);
	policyMenu->addAction(selinuxYumAct);
	policyMenu->addAction(enforcingAct);
	policyMenu->addAction(check_selinuxAct);
	policyMenu->addAction(default_policyAct);
	policyMenu->addAction(selinux_pathAct);
	policyMenu->addAction(segatex_getseuserbynameAct);

	manageMenu = menuBar()->addMenu(tr("&Modules"));
	manageMenu->addAction(semodule_core_processAct);
	manageMenu->addAction(policygeneration_processAct);

	semanageMenu = menuBar()->addMenu(tr("&Semanage"));
	semanageMenu->addAction(semanage_core_processAct);
	semanageMenu->addAction(semanage_core_login_processAct);
	semanageMenu->addAction(semanage_core_fcontext_processAct);
	semanageMenu->addAction(semanage_core_port_processAct);
	semanageMenu->addAction(semanage_core_translation_processAct);
	semanageMenu->addAction(semanage_core_boolean_processAct);
	semanageMenu->addAction(semanage_core_permissive_processAct);
	semanageMenu->addAction(seinfoAct);

	relabelMenu = menuBar()->addMenu(tr("Re&label"));
	relabelMenu->addAction(restoreconAct);
	relabelMenu->addAction(autorelabel_processAct);

	downloaderMenu = menuBar()->addMenu(tr("&Download"));
	downloaderMenu->addAction(downloaderAct);

	breakteMenu = menuBar()->addMenu(tr("Break .&te"));
	breakteMenu->addAction(breakteAct);

	breakifMenu = menuBar()->addMenu(tr("Break .&if"));
	breakifMenu->addAction(breakifAct);

	miscellaneousMenu = menuBar()->addMenu(tr("Mis&c"));
	miscellaneousMenu->addAction(useraddAct);
	miscellaneousMenu->addAction(seeprocessAct);

	helpMenu = menuBar()->addMenu(tr("&Help"));
	helpMenu->addAction(howtouseAct);
	helpMenu->addAction(aboutAct);
	helpMenu->addAction(aboutQtAct);

}
void MainWindow::createActions()
{
	newAct = new QAction(QIcon(":/images/new.png"), tr("&New"), this);
	newAct->setShortcut(tr("Ctrl+N"));
	newAct->setStatusTip(tr("Create a new file"));
	connect(newAct, SIGNAL(triggered()), this, SLOT(newFile()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	openAct = new QAction(QIcon(":/images/open.png"), tr("&Open..."), this);
	openAct->setShortcut(tr("Ctrl+O"));
	openAct->setStatusTip(tr("Open an existing file"));
	connect(openAct, SIGNAL(triggered()), this, SLOT(open()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	saveAct = new QAction(QIcon(":/images/save.png"), tr("&Save"), this);
	saveAct->setShortcut(tr("Ctrl+S"));
	saveAct->setStatusTip(tr("Save the document to disk"));
	connect(saveAct, SIGNAL(triggered()), this, SLOT(save()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	saveAsAct = new QAction(tr("Save &As..."), this);
	saveAsAct->setStatusTip(tr("Save the document under a new name"));
	connect(saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	exitAct = new QAction(tr("E&xit"), this);
	exitAct->setShortcut(tr("Ctrl+Q"));
	exitAct->setStatusTip(tr("Exit the application"));
	connect(exitAct, SIGNAL(triggered()), qApp, SLOT(closeAllWindows()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	cutAct = new QAction(QIcon(":/images/cut.png"), tr("Cu&t"), this);
	cutAct->setShortcut(tr("Ctrl+X"));
	cutAct->setStatusTip(tr("Cut the current selection's contents to the "
			     "clipboard"));
	connect(cutAct, SIGNAL(triggered()), this, SLOT(cut()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	copyAct = new QAction(QIcon(":/images/copy.png"), tr("&Copy"), this);
	copyAct->setShortcut(tr("Ctrl+C"));
	copyAct->setStatusTip(tr("Copy the current selection's contents to the "
			      "clipboard"));
	connect(copyAct, SIGNAL(triggered()), this, SLOT(copy()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	pasteAct = new QAction(QIcon(":/images/paste.png"), tr("&Paste"), this);
	pasteAct->setShortcut(tr("Ctrl+V"));
	pasteAct->setStatusTip(tr("Paste the clipboard's contents into the current "
			       "selection"));
	connect(pasteAct, SIGNAL(triggered()), this, SLOT(paste()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	closeAct = new QAction(tr("Cl&ose"), this);
	closeAct->setShortcut(tr("Ctrl+F4"));
	closeAct->setStatusTip(tr("Close the active window"));
	connect(closeAct, SIGNAL(triggered()),
	     mdiArea, SLOT(closeActiveSubWindow()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	closeAllAct = new QAction(tr("Close &All"), this);
	closeAllAct->setStatusTip(tr("Close all the windows"));
	connect(closeAllAct, SIGNAL(triggered()),
	     mdiArea, SLOT(closeAllSubWindows()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	tileAct = new QAction(tr("&Tile"), this);
	tileAct->setStatusTip(tr("Tile the windows"));
	connect(tileAct, SIGNAL(triggered()), mdiArea, SLOT(tileSubWindows()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	cascadeAct = new QAction(tr("&Cascade"), this);
	cascadeAct->setStatusTip(tr("Cascade the windows"));
	connect(cascadeAct, SIGNAL(triggered()), mdiArea, SLOT(cascadeSubWindows()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	nextAct = new QAction(tr("Ne&xt"), this);
	nextAct->setStatusTip(tr("Move the focus to the next window"));
	connect(nextAct, SIGNAL(triggered()),
	     mdiArea, SLOT(activateNextSubWindow()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	previousAct = new QAction(tr("Pre&vious"), this);
	previousAct->setStatusTip(tr("Move the focus to the previous "
				  "window"));
	connect(previousAct, SIGNAL(triggered()),
	     mdiArea, SLOT(activatePreviousSubWindow()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	separatorAct = new QAction(this);
	separatorAct->setSeparator(true);

/////////////////////// Policy ////////////////////////////////////////
	sqlrefpolicyAct = new QAction(tr("&Refpolicy Analizer"), this);
	sqlrefpolicyAct->setStatusTip(tr("Analyze refpolicy"));
	connect(sqlrefpolicyAct, SIGNAL(activated()), this, SLOT(sqlrefpolicy()));
	connect(sqlrefpolicyAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selinuxYumAct = new QAction(tr("&Yum install/update"), this);
	selinuxYumAct->setStatusTip(tr("Yum install/update SELinux related RPMs."));
	connect(selinuxYumAct, SIGNAL(activated()), this, SLOT(yum_selinux()));
	connect(selinuxYumAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	check_selinuxAct = new QAction(tr("&Check SELinux state"), this);
	check_selinuxAct->setStatusTip(tr("Check SELinux State at present"));
	connect(check_selinuxAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	default_policyAct = new QAction(tr("&Default SELinux policy type"), this);
	default_policyAct->setStatusTip(tr("Check SELinux default policy type"));
	connect(default_policyAct, SIGNAL(activated()), segatex_state, SLOT(default_policy_type()));
	connect(default_policyAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	enforcingAct = new QAction(tr("Change SELinux &state"), this);
	enforcingAct->setStatusTip(tr("Change Enforcing / Permissive"));
	connect(enforcingAct, SIGNAL(activated()), this, SLOT(enforcing()));
	connect(enforcingAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	selinux_pathAct = new QAction(tr("Check SELinux &path"), this);
	selinux_pathAct->setStatusTip(tr("Check SELinux path"));
	connect(selinux_pathAct, SIGNAL(activated()), segatex_state, SLOT(segatex_selinux_path()));
	connect(selinux_pathAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	segatex_getseuserbynameAct = new QAction(tr("Get se&user and level from linuxuser"), this);
	segatex_getseuserbynameAct->setStatusTip(tr("Get seuser and level from linuxuser"));
	connect(segatex_getseuserbynameAct, SIGNAL(activated()), this, SLOT(segatex_getseuserbyname()));
	connect(segatex_getseuserbynameAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Audit ////////////////////////////////////////
	semodule_dontauditAct = new QAction(tr("dont&audit"), this);
	semodule_dontauditAct->setStatusTip(tr("manage dontaudit"));
	connect(semodule_dontauditAct, SIGNAL(activated()), this, SLOT(semodule_dontaudit()));
	connect(semodule_dontauditAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	segatex_coreAct = new QAction(tr("Analize audit.&log"), this);
	segatex_coreAct->setStatusTip(tr("Analize audit.log in many ways."));
	connect(segatex_coreAct, SIGNAL(activated()), this, SLOT(segatex_core()));
	connect(segatex_coreAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	audit2allowAct = new QAction(tr("Audi&t2allow"), this);
	audit2allowAct->setStatusTip(tr("audit2allow"));
	connect(audit2allowAct, SIGNAL(activated()), this, SLOT(audit2allow()));
	connect(audit2allowAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	aureportAct = new QAction(tr("Au&report"), this);
	aureportAct->setStatusTip(tr("Aureport"));
	connect(aureportAct, SIGNAL(activated()), this, SLOT(aureport()));
	connect(aureportAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	ausearchAct = new QAction(tr("Au&search"), this);
	aureportAct->setStatusTip(tr("Ausearch"));
	connect(ausearchAct, SIGNAL(activated()), this, SLOT(ausearch()));
	connect(ausearchAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
////////////////////// Modules /////////////////////////////////////////
	semodule_core_processAct = new QAction(tr("&Modules"), this);
	semodule_core_processAct->setStatusTip(tr("Modules."));
	connect(semodule_core_processAct, SIGNAL(activated()), this, SLOT(semodule_core_process()));
	connect(semodule_core_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	policygeneration_processAct = new QAction(tr("Policy_&module "), this);
	policygeneration_processAct->setStatusTip(tr("Generate policy_module."));
	connect(policygeneration_processAct, SIGNAL(activated()), this, SLOT(policygeneration_process()));
	connect(policygeneration_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
//////////////////////  Semanage /////////////////////////////////////////
	semanage_core_processAct = new QAction(tr("&list objects"), this);
	semanage_core_processAct->setStatusTip(tr("Semanage login -l user -l boolean -l port -l interface -l fcontext -l translation -l."));
	connect(semanage_core_processAct, SIGNAL(activated()), this, SLOT(semanage_core_process()));
	connect(semanage_core_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_login_processAct = new QAction(tr("semanage l&ogin"), this);
	semanage_core_login_processAct->setStatusTip(tr("Semanage login -a -m -d."));
	connect(semanage_core_login_processAct, SIGNAL(activated()), this, SLOT(semanage_core_login_process()));
	connect(semanage_core_login_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_fcontext_processAct = new QAction(tr("semanage &fcontext"), this);
	semanage_core_fcontext_processAct->setStatusTip(tr("Semanage fcontext -a -m -d."));
	connect(semanage_core_fcontext_processAct, SIGNAL(activated()), this, SLOT(semanage_core_fcontext_process()));
	connect(semanage_core_fcontext_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_port_processAct = new QAction(tr("semanage &port"), this);
	semanage_core_port_processAct->setStatusTip(tr("Semanage port -a -m -d."));
	connect(semanage_core_port_processAct, SIGNAL(activated()), this, SLOT(semanage_core_port_process()));
	connect(semanage_core_port_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_translation_processAct = new QAction(tr("semanage &translation"), this);
	semanage_core_translation_processAct->setStatusTip(tr("Semanage translation -a -m -d."));
	connect(semanage_core_translation_processAct, SIGNAL(activated()), this, SLOT(semanage_core_translation_process()));
	connect(semanage_core_translation_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_boolean_processAct = new QAction(tr("setse&bool "), this);
	semanage_core_boolean_processAct->setStatusTip(tr("setsebool [-P] boolean value."));
	connect(semanage_core_boolean_processAct, SIGNAL(activated()), this, SLOT(semanage_core_boolean_process()));
	connect(semanage_core_boolean_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	semanage_core_permissive_processAct = new QAction(tr("semanage &permissive"), this);
	semanage_core_permissive_processAct->setStatusTip(tr("Semanage permissive -a -d."));
	connect(semanage_core_permissive_processAct, SIGNAL(activated()), this, SLOT(semanage_core_permissive_process()));
	connect(semanage_core_permissive_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	seinfoAct = new QAction(tr("se&info"), this);
	seinfoAct->setStatusTip(tr("Seinfo [options]"));
	connect(seinfoAct, SIGNAL(activated()), this, SLOT(seinfo()));
	connect(seinfoAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Relabel ////////////////////////////////////////////////
	restoreconAct = new QAction(tr("&restorecon"), this);
	restoreconAct->setStatusTip(tr("restorecon"));
	connect(restoreconAct, SIGNAL(activated()), this, SLOT(restorecon()));
	connect(restoreconAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	autorelabel_processAct = new QAction(tr("autore&label "), this);
	autorelabel_processAct->setStatusTip(tr("autorelabel the system."));
	connect(autorelabel_processAct, SIGNAL(activated()), this, SLOT(autorelabel_process()));
	connect(autorelabel_processAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Misc ///////////////////////////////////////////
	useraddAct = new QAction(tr("&Useradd/delete"), this);
	useraddAct->setStatusTip(tr("useradd/delete"));
	connect(useraddAct, SIGNAL(activated()), this, SLOT(useradd()));
	connect(useraddAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	seeprocessAct = new QAction(tr("&see process"), this);
	seeprocessAct->setStatusTip(tr("see process"));
	connect(seeprocessAct, SIGNAL(activated()), this, SLOT(seeprocess()));
	connect(seeprocessAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Download ///////////////////////////////////////////
	downloaderAct = new QAction(tr("&download Fedora"), this);
	downloaderAct->setStatusTip(tr("download Fedora"));
	connect(downloaderAct, SIGNAL(activated()), this, SLOT(downloader()));
	connect(downloaderAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Break .te ///////////////////////////////////////////
	breakteAct = new QAction(tr("Breake &te"), this);
	breakteAct->setStatusTip(tr("Break .te files"));
	connect(breakteAct, SIGNAL(activated()), this, SLOT(break_te()));
	connect(breakteAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Break .if ///////////////////////////////////////////
	breakifAct = new QAction(tr("Breake &if"), this);
	breakifAct->setStatusTip(tr("Break .if files"));
	connect(breakifAct, SIGNAL(activated()), this, SLOT(break_if()));
	connect(breakifAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
/////////////////////// Help ////////////////////////////////////////
	howtouseAct = new QAction(tr("&How to use"), this);
	howtouseAct->setStatusTip(tr("Show the application's How to use box"));
	connect(howtouseAct, SIGNAL(activated()), this, SLOT(howtouse()));
	connect(howtouseAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	aboutAct = new QAction(tr("&About"), this);
	aboutAct->setStatusTip(tr("Show the application's About box"));
	connect(aboutAct, SIGNAL(triggered()), this, SLOT(about()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));

	aboutQtAct = new QAction(tr("About &Qt"), this);
	aboutQtAct->setStatusTip(tr("Show the Qt library's About box"));
	connect(aboutQtAct, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
	connect(newAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
}


void MainWindow::updateSegatexStateIndicator()
{
	selinux_policy = createStatusBar_pre();
	segatexStateLabel->clear();
	segatexStateLabel->setText(tr(selinux_policy));
}
void MainWindow::openFile(const QString &fileName)
{
    Editor *editor = createEditor();
    if (editor->openFile(fileName))
        editor->show();
    else
        editor->close();
}
void MainWindow::closeEvent(QCloseEvent *event)
{
	mdiArea->closeAllSubWindows();
	if (activeMdiChild()) {
		event->ignore();
	} else {
		writeSettings();
		event->accept();
	}
}
 void MainWindow::newFile()
 {
     MdiChild *child = createMdiChild();
     child->newFile();
     child->show();
 }
void MainWindow::open()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),"/usr/share/segatex",tr("Type Enforcement files(*.te);;File Context files(*.fc);;Interface files(*.if);;raw files(*raw);;policy module files(*.pp);;text files(*.txt);;csv files(*.csv);;Any files(*)"));
	if (!fileName.isEmpty()) {
		QMdiSubWindow *existing = findMdiChild(fileName);
		if (existing) {
			mdiArea->setActiveSubWindow(existing);
		return;
		}
		MdiChild *child = createMdiChild();
		if (child->loadFile(fileName)) {
			statusBar()->showMessage(tr("File loaded"), 2000);
			child->show();
		} else {
			child->close();
		}
	}
}
 void MainWindow::save()
 {
     if (activeMdiChild() && activeMdiChild()->save())
         statusBar()->showMessage(tr("File saved"), 2000);
 }
 void MainWindow::saveAs()
 {
     if (activeMdiChild() && activeMdiChild()->saveAs())
         statusBar()->showMessage(tr("File saved"), 2000);
 }
 void MainWindow::cut()
 {
     if (activeMdiChild())
         activeMdiChild()->cut();
 }
 void MainWindow::copy()
 {
     if (activeMdiChild())
         activeMdiChild()->copy();
 }
 void MainWindow::paste()
 {
     if (activeMdiChild())
         activeMdiChild()->paste();
 }
void MainWindow::about()
{
	QMessageBox::about(this, tr("About segatex"),
		tr("<h2>segatex-7.780</h2>"
		"<p>Copyright &copy; 2007-2009"
		"<p>Shintaro Fujiwara."
		"<p>segatex is a SELinux tool"
		"<p><b>written with Qt</b>."));
}
 void MainWindow::updateMenus()
 {
     bool hasMdiChild = (activeMdiChild() != 0);
     saveAct->setEnabled(hasMdiChild);
     saveAsAct->setEnabled(hasMdiChild);
     pasteAct->setEnabled(hasMdiChild);
     closeAct->setEnabled(hasMdiChild);
     closeAllAct->setEnabled(hasMdiChild);
     tileAct->setEnabled(hasMdiChild);
     cascadeAct->setEnabled(hasMdiChild);
     nextAct->setEnabled(hasMdiChild);
     previousAct->setEnabled(hasMdiChild);
     separatorAct->setVisible(hasMdiChild);
     bool hasSelection = (activeMdiChild() &&
                          activeMdiChild()->textCursor().hasSelection());
     cutAct->setEnabled(hasSelection);
     copyAct->setEnabled(hasSelection);
 }
 void MainWindow::updateWindowMenu()
 {
     windowMenu->clear();
     windowMenu->addAction(closeAct);
     windowMenu->addAction(closeAllAct);
     windowMenu->addSeparator();
     windowMenu->addAction(tileAct);
     windowMenu->addAction(cascadeAct);
     windowMenu->addSeparator();
     windowMenu->addAction(nextAct);
     windowMenu->addAction(previousAct);
     windowMenu->addAction(separatorAct);
     QList<QMdiSubWindow *> windows = mdiArea->subWindowList();
     separatorAct->setVisible(!windows.isEmpty());
     for (int i = 0; i < windows.size(); ++i) {
         MdiChild *child = qobject_cast<MdiChild *>(windows.at(i)->widget());
         QString text;
         if (i < 9) {
             text = tr("&%1 %2").arg(i + 1)
                                .arg(child->userFriendlyCurrentFile());
         } else {
             text = tr("%1 %2").arg(i + 1)
                               .arg(child->userFriendlyCurrentFile());
         }
         QAction *action  = windowMenu->addAction(text);
         action->setCheckable(true);
         action ->setChecked(child == activeMdiChild());
         connect(action, SIGNAL(triggered()), windowMapper, SLOT(map()));
         windowMapper->setMapping(action, windows.at(i));
     }
 }
MdiChild *MainWindow::createMdiChild()
{
	MdiChild *child = new MdiChild;
	mdiArea->addSubWindow(child);
	connect(child, SIGNAL(copyAvailable(bool)),
	cutAct, SLOT(setEnabled(bool)));
	connect(child, SIGNAL(copyAvailable(bool)),
	copyAct, SLOT(setEnabled(bool)));
	return child;
}
 void MainWindow::createToolBars()
 {
     fileToolBar = addToolBar(tr("File"));
     fileToolBar->addAction(newAct);
     fileToolBar->addAction(openAct);
     fileToolBar->addAction(saveAct);
     editToolBar = addToolBar(tr("Edit"));
     editToolBar->addAction(cutAct);
     editToolBar->addAction(copyAct);
     editToolBar->addAction(pasteAct);
 }
 QString MainWindow::createStatusBar_pre()
 {
	selinux_policy = segatex_state->loaded_policy();
	enabled_or_not_str = segatex_state->is_selinux_enabled_segatex();
	getenforce_str = segatex_state->getenforce_segatex();
	segatex_selinux_policy_root_str = segatex_state->segatex_selinux_policy_root();
	segatex_security_policyvers_int = segatex_state->segatex_security_policyvers();
	//segatex_security_policyvers_str = (QString)segatex_security_policyvers_int;
	if(enabled_or_not_str == "disabled")
	{
		selinux_policy = "SELinux is fully " + enabled_or_not_str + ".";
		segatexStateLabel->setPaletteBackgroundColor(QColor(255, 122, 162));
	}
	else
	{
		selinux_policy = "SELinux is " + enabled_or_not_str + " and policy " + selinux_policy + " " + getenforce_str + " is in use."
		//+ " Policy root is " + segatex_selinux_policy_root_str + " and version is " + segatex_security_policyvers_str + ".";
		+ " Policy root is " + segatex_selinux_policy_root_str;
		/*
		if(getenforce_str == "enforcing")
			segatexStateLabel->setPaletteBackgroundColor(QColor(155, 155, 255));
		if(getenforce_str == "permissive")
			segatexStateLabel->setPaletteBackgroundColor(QColor(255, 251, 126));
		*/
	}
	return selinux_policy;
 }
 void MainWindow::createStatusBar()
 {
	readyLabel = new QLabel(tr(" Ready"), this);

	modLabel = new QLabel(tr(" MOD "), this);

	selinux_policy = createStatusBar_pre();
	segatexStateLabel = new QLabel(tr(selinux_policy), this);
	segatexStateLabel->setAlignment(Qt::AlignHCenter);
	segatex_security_policyvers_int = segatex_state->segatex_security_policyvers();
/////////////////////test////////////////
	//segatex_security_policyvers_const_char = (const char *)segatex_security_policyvers_int;	
	//segatexStateLabel2 = new QLabel(tr(segatex_security_policyvers_const_char), this);
	//segatexStateLabel2->setAlignment(Qt::AlignHCenter);
/////////////////////end test////////////////

	modLabel->setAlignment(Qt::AlignHCenter);
	modLabel->setMinimumSize(modLabel->sizeHint());
	modLabel->clear();

	statusBar()->addWidget(readyLabel, 1);
	statusBar()->addWidget(modLabel);
	statusBar()->addWidget(segatexStateLabel, 1);
 }
 void MainWindow::readSettings()
 {
     QSettings settings("Trolltech", "MDI Example");
     QPoint pos = settings.value("pos", QPoint(200, 200)).toPoint();
     QSize size = settings.value("size", QSize(400, 400)).toSize();
     move(pos);
     resize(size);
 }
 void MainWindow::writeSettings()
 {
     QSettings settings("Trolltech", "MDI Example");
     settings.setValue("pos", pos());
     settings.setValue("size", size());
 }
 MdiChild *MainWindow::activeMdiChild()
 {
     if (QMdiSubWindow *activeSubWindow = mdiArea->activeSubWindow())
         return qobject_cast<MdiChild *>(activeSubWindow->widget());
     return 0;
 }
 QMdiSubWindow *MainWindow::findMdiChild(const QString &fileName)
 {
     QString canonicalFilePath = QFileInfo(fileName).canonicalFilePath();
     foreach (QMdiSubWindow *window, mdiArea->subWindowList()) {
         MdiChild *mdiChild = qobject_cast<MdiChild *>(window->widget());
         if (mdiChild->currentFile() == canonicalFilePath)
             return window;
     }
     return 0;
 }
//this would be the one?
void MainWindow::switchLayoutDirection()
{
	if (layoutDirection() == Qt::LeftToRight)
		qApp->setLayoutDirection(Qt::RightToLeft);
	else
		qApp->setLayoutDirection(Qt::LeftToRight);
}
 void MainWindow::setActiveSubWindow(QWidget *window)
 {
     if (!window)
         return;
     mdiArea->setActiveSubWindow(qobject_cast<QMdiSubWindow *>(window));
 }
void MainWindow::updateModIndicator()
{
    if (activeEditor() && activeEditor()->isModified())
        modLabel->setText(tr("MOD"));
    else
        modLabel->clear();
}
Editor *MainWindow::createEditor()
{
	Editor *editor = new Editor(workspace);
	connect(editor, SIGNAL(copyAvailable(bool)),
	    this, SLOT(copyAvailable(bool)));
	connect(editor, SIGNAL(modificationChanged(bool)),
	    this, SLOT(updateModIndicator()));
	return editor;
}
Editor *MainWindow::activeEditor()
{
    return (Editor *)workspace->activeWindow();
}
//newly added
void MainWindow::break_te()
{
	if(!breakte_o) {
		breakte_o = new BreakTe(this);
	}
	breakte_o->show();
	breakte_o->raise();
	breakte_o->setActiveWindow();
}
void MainWindow::break_if()
{
	if(!breakif_o) {
		breakif_o = new BreakIf(this);
	}
	breakif_o->show();
	breakif_o->raise();
	breakif_o->setActiveWindow();
}
void MainWindow::yum_selinux()
{
	if(!selinux_yum) {
		selinux_yum = new SegatexYum(this);
	}
	selinux_yum->show();
	selinux_yum->raise();
	selinux_yum->setActiveWindow();
}
void MainWindow::yum_selinux_process()
{
	if(!selinux_yum_process) {
		selinux_yum_process = new SegatexYumProcess(this);
	}
	selinux_yum_process->show();
	selinux_yum_process->raise();
	selinux_yum_process->setActiveWindow();
}
void MainWindow::audit2allow()
{
	if(!selinux_audit2allow) {
		selinux_audit2allow = new SegatexAudit2allow(this);
	}
	selinux_audit2allow->show();
	selinux_audit2allow->raise();
	selinux_audit2allow->setActiveWindow();
}
void MainWindow::segatex_core()
{
	if(!segatex_core_o) {
		segatex_core_o = new SegatexCore(this);
	}
	segatex_core_o->show();
	segatex_core_o->raise();
	segatex_core_o->setActiveWindow();
}
void MainWindow::semodule_core_process()
{
	if(!semodule_core_process_o) {
		semodule_core_process_o = new SemoduleCoreProcess(this);
	}
	semodule_core_process_o->show();
	semodule_core_process_o->raise();
	semodule_core_process_o->setActiveWindow();
}
void MainWindow::semanage_core_process()
{
	if(!semanage_core_process_o) {
		semanage_core_process_o = new SemanageCoreProcess(this);
	}
	semanage_core_process_o->show();
	semanage_core_process_o->raise();
	semanage_core_process_o->setActiveWindow();
}
void MainWindow::semanage_core_login_process()
{
	if(!semanage_core_login_process_o) {
		semanage_core_login_process_o = new SemanageCoreLoginProcess(this);
	}
	semanage_core_login_process_o->show();
	semanage_core_login_process_o->raise();
	semanage_core_login_process_o->setActiveWindow();
}
void MainWindow::semanage_core_fcontext_process()
{
	if(!semanage_core_fcontext_process_o) {
		semanage_core_fcontext_process_o = new SemanageCoreFcontextProcess(this);
	}
	semanage_core_fcontext_process_o->show();
	semanage_core_fcontext_process_o->raise();
	semanage_core_fcontext_process_o->setActiveWindow();
}
void MainWindow::semanage_core_port_process()
{
	if(!semanage_core_port_process_o) {
		semanage_core_port_process_o = new SemanageCorePortProcess(this);
	}
	semanage_core_port_process_o->show();
	semanage_core_port_process_o->raise();
	semanage_core_port_process_o->setActiveWindow();
}
void MainWindow::semanage_core_translation_process()
{
	if(!semanage_core_translation_process_o) {
		semanage_core_translation_process_o = new SemanageCoreTranslationProcess(this);
	}
	semanage_core_translation_process_o->show();
	semanage_core_translation_process_o->raise();
	semanage_core_translation_process_o->setActiveWindow();
}
void MainWindow::semanage_core_boolean_process()
{
	if(!semanage_core_boolean_process_o) {
		semanage_core_boolean_process_o = new SemanageCoreBooleanProcess(this);
	}
	semanage_core_boolean_process_o->show();
	semanage_core_boolean_process_o->raise();
	semanage_core_boolean_process_o->setActiveWindow();
}
void MainWindow::semanage_core_permissive_process()
{
	if(!semanage_core_permissive_process_o) {
		semanage_core_permissive_process_o = new SemanageCorePermissiveProcess(this);
	}
	semanage_core_permissive_process_o->show();
	semanage_core_permissive_process_o->raise();
	semanage_core_permissive_process_o->setActiveWindow();
}
void MainWindow::seinfo()
{
	if(!seinfo_o) {
		seinfo_o = new Seinfo(this);
	}
	seinfo_o->show();
	seinfo_o->raise();
	seinfo_o->setActiveWindow();
}
void MainWindow::autorelabel_process()
{
	if(!autorelabel_process_o) {
		autorelabel_process_o = new AutoRelabel(this);
	}
	autorelabel_process_o->show();
	autorelabel_process_o->raise();
	autorelabel_process_o->setActiveWindow();
}
void MainWindow::policygeneration_process()
{
	if(!policygeneration_process_o) {
		policygeneration_process_o = new Policygeneration(this);
	}
	policygeneration_process_o->show();
	policygeneration_process_o->raise();
	policygeneration_process_o->setActiveWindow();
}
void MainWindow::aureport()
{
	if(!aureport_o) {
		aureport_o = new Aureport(this);
	}
	aureport_o->show();
	aureport_o->raise();
	aureport_o->setActiveWindow();
}
void MainWindow::ausearch()
{
	if(!ausearch_o) {
		ausearch_o = new Ausearch(this);
	}
	ausearch_o->show();
	ausearch_o->raise();
	ausearch_o->setActiveWindow();
}
void MainWindow::useradd()
{
	if(!useradd_o) {
		useradd_o = new Useradd(this);
	}
	useradd_o->show();
	useradd_o->raise();
	useradd_o->setActiveWindow();
}
void MainWindow::seeprocess()
{
	if(!seeprocess_o) {
		seeprocess_o = new Seeprocess(this);
	}
	seeprocess_o->show();
	seeprocess_o->raise();
	seeprocess_o->setActiveWindow();
}
void MainWindow::restorecon()
{
	if(!restorecon_o) {
		restorecon_o = new Restorecon(this);
	}
	restorecon_o->show();
	restorecon_o->raise();
	restorecon_o->setActiveWindow();
}
void MainWindow::downloader()
{
	if(!downloader_o) {
		downloader_o = new Downloader(this);
	}
	downloader_o->show();
	downloader_o->raise();
	downloader_o->setActiveWindow();
}
void MainWindow::semodule_dontaudit()
{
	if(!semodule_dontaudit_o) {
		semodule_dontaudit_o = new SemoduleDontaudit(this);
	}else{
		delete semodule_dontaudit_o;
		semodule_dontaudit_o = new SemoduleDontaudit(this);
	}
	semodule_dontaudit_o->show();
	semodule_dontaudit_o->raise();
	semodule_dontaudit_o->setActiveWindow();
}
void MainWindow::sqlrefpolicy()
{
	//if(!sqlrefpolicy_o) {
		sqlrefpolicy_o = new Sqlrefpolicy(this);
	//}
	sqlrefpolicy_o->show();
	sqlrefpolicy_o->raise();
	sqlrefpolicy_o->setActiveWindow();
}
void MainWindow::segatex_getseuserbyname()
{
	if(!segatex_getseuserbyname_o) {
		segatex_getseuserbyname_o = new SegatexGetseuserbyname(this);
	}
	segatex_getseuserbyname_o->show();
	segatex_getseuserbyname_o->raise();
	segatex_getseuserbyname_o->setActiveWindow();
}
void MainWindow::howtouse()
{
	QMessageBox::about(this, tr("How to use"),
		tr("<h2>How to use segatex</h2>"
		"<p><font color=\"blue\">[segatex]</font>"
		"<p>You can set selinux enforcing"
		" and permissive just pushing button."
		" You can install/update SELinux related"
		" RPMs.You can audit2allow"
		" You can analize audit log."
		" You can manage modules."
		" You can semanage."
		" You can setsebool."
		" You can relabel the system."
		" You can generate brand-new policy module."
		" You can generate interfaced policy,by "
		" Analize audit.log-generate policy."
		" You can aureport."
		" You can ausearch."
		" You can restorecon."
		" You can add/delete Linux user."
		" You can ftp download."
		" You can analyze refpolicy."
		"<p><font color=\"blue\">[segatex_editor]</font>"
		"<p>Push break .te or .if"
		""));
}
void MainWindow::enforcing()
{
	if(!segatex_apply) {
		segatex_apply = new SegatexApply(this);
		connect(segatex_apply, SIGNAL(enforcingOn()), segatex_apply, SLOT(setenforce_enforcing())); 
		connect(segatex_apply, SIGNAL(permissiveOn()), segatex_apply, SLOT(setenforce_permissive())); 
//for test
		connect(segatex_apply, SIGNAL(permissiveOn()), this, SLOT(updateSegatexStateIndicator()));
		connect(segatex_apply, SIGNAL(enforcingOn()), this, SLOT(updateSegatexStateIndicator()));
//end for test
		connect(segatex_apply, SIGNAL(disabledOn()), segatex_apply, SLOT(setenforce_disabled())); 
		connect(previousAct, SIGNAL(activated()), this, SLOT(updateSegatexStateIndicator()));
	}
	segatex_apply->show();
	segatex_apply->raise();
	segatex_apply->setActiveWindow();
}
