/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qmessagebox.h>

#include "segatex_state.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexState::SegatexState(){}

/* returns selinux loaded policy as QString*/
QString SegatexState::loaded_policy()
{
	QRegExp rx_policy_targeted("targeted");
	QRegExp rx_policy_minimum("minimum");
	QRegExp rx_policy_mls("mls");

	pol_root = selinux_default_type_path();
		
	if( pol_root.find( rx_policy_targeted, 0) != -1){
                loaded_policy_str= tr("targeted");
        }
	if( pol_root.find( rx_policy_minimum, 0) != -1){
                loaded_policy_str= tr("minimum");
        }
	if( pol_root.find( rx_policy_mls, 0) != -1){
                loaded_policy_str= tr("mls");
        }

        return loaded_policy_str;
}

/* returns selinux is enabled or not as QString*/
QString SegatexState::is_selinux_enabled_segatex()
{
	enabled_or_not = is_selinux_enabled();
	if(enabled_or_not == 1)
		enabled_or_not_str = tr("enabled");
	else
		enabled_or_not_str = tr("disabled");

	return enabled_or_not_str;
}

/* returns getenforce as QString*/
QString SegatexState::getenforce_segatex()
{
	getenforce = security_getenforce();
	if(getenforce == 1)
		getenforce_str = tr("enforcing");
	else if(getenforce == 0)
		getenforce_str = tr("permissive");
	else
		getenforce_str = tr("disabled");

	return getenforce_str;
}
/* returns selinux default policy type as QString*/
QString SegatexState::default_policy_type()
{
	/*I don't know why, but it returns ok.;)*/
	char *policy_type;
	policy_type = "targeted";
	//char **policy_type_ptr;
	//policy_type_ptr = &policy_type;
	selinux_getpolicytype(&policy_type);
	default_policy_type_str = *&policy_type;
	free(policy_type);
	default_policy_type_str_tr = tr(default_policy_type_str);

	default_getenforcemode_str = default_getenforcemode();

	QMessageBox::information(this,tr(""),tr("SELinux default policy is " + default_policy_type_str_tr
					 + " and should be started in " + default_getenforcemode_str + "!"));

        return default_policy_type_str;
}
/* returns selinux policy root as QString */
QString SegatexState::segatex_selinux_policy_root()
{
	segatex_selinux_policy_root_str = selinux_policy_root();
	return segatex_selinux_policy_root_str;
}
/* returns selinux policy version as int */
int SegatexState::segatex_security_policyvers()
{
	segatex_security_policyvers_int = security_policyvers();
	return segatex_security_policyvers_int;
}
/* returns selinux path as QString*/
int SegatexState::segatex_selinux_path()
{
	selinux_binary_policy_path_str = selinux_binary_policy_path();
	selinux_failsafe_context_path_str = selinux_failsafe_context_path();
	selinux_removable_context_path_str = selinux_removable_context_path();
	selinux_default_context_path_str = selinux_default_context_path();
	selinux_user_contexts_path_str = selinux_user_contexts_path();
	selinux_file_context_path_str = selinux_file_context_path();
	selinux_file_context_homedir_path_str= selinux_file_context_homedir_path();
	selinux_file_context_local_path_str = selinux_file_context_local_path();
	selinux_file_context_subs_path_str = selinux_file_context_subs_path();
	selinux_homedir_context_path_str = selinux_homedir_context_path();
	selinux_media_context_path_str = selinux_media_context_path();
	selinux_virtual_domain_context_path_str = selinux_virtual_domain_context_path();
	selinux_virtual_image_context_path_str = selinux_virtual_image_context_path();
	selinux_x_context_path_str = selinux_x_context_path();
	selinux_contexts_path_str = selinux_contexts_path();
	selinux_securetty_types_path_str = selinux_securetty_types_path();
	selinux_booleans_path_str = selinux_booleans_path();
	selinux_customizable_types_path_str = selinux_customizable_types_path();
	selinux_users_path_str = selinux_users_path();
	selinux_usersconf_path_str = selinux_usersconf_path();
	selinux_translations_path_str = selinux_translations_path();
	selinux_colors_path_str = selinux_colors_path();
	selinux_netfilter_context_path_str = selinux_netfilter_context_path();
	selinux_path_str = selinux_path();

	QMessageBox::about(this,tr("SELinux path"),
		tr("<p>SELinux binary_policy_path is"
		"<br />"
		"<font color=\"blue\">" + selinux_binary_policy_path_str + "</font>"
		"<br />"
		"SELinux failsafe context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_failsafe_context_path_str +"</font>"
		"<br />"
		"SELinux removable context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_removable_context_path_str +"</font>"
		"<br />"
		"SELinux default context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_default_context_path_str +"</font>"
		"<br />"
		"SELinux user contexts path is"
		"<br />"
		"<font color=\"blue\">" + selinux_user_contexts_path_str + "</font>"
		"<br />"
		"SELinux file context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_file_context_path_str + "</font>"
		"<br />"
		"SELinux file context homedir path is"
		"<br />"
		"<font color=\"blue\">" + selinux_file_context_homedir_path_str + "</font>"
		"<br />"
		"SELinux file context local path is"
		"<br />"
		"<font color=\"blue\">" + selinux_file_context_local_path_str + "</font>"
		"<br />"
		"SELinux file context subs path is"
		"<br />"
		"<font color=\"blue\">" + selinux_file_context_subs_path_str + "</font>"
		"<br />"
		"SELinux homedir context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_homedir_context_path_str + "</font>"
		"<br />"
		"SELinux media context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_media_context_path_str + "</font>"
		"<br />"
		"SELinux virtual domain context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_virtual_domain_context_path_str + "</font>"
		"<br />"
		"SELinux virtual image context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_virtual_image_context_path_str + "</font>"
		"<br />"
		"SELinux x context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_x_context_path_str + "</font>"
		"<br />"
		"SELinux contexts path is"
		"<br />"
		"<font color=\"blue\">" + selinux_contexts_path_str + "</font>"
		"<br />"
		"SELinux securetty types path is"
		"<br />"
		"<font color=\"blue\">" + selinux_securetty_types_path_str + "</font>"
		"<br />"
		"SELinux booleans path is"
		"<br />"
		"<font color=\"blue\">" + selinux_booleans_path_str + "</font>"
		"<br />"
		"SELinux customizable types path is"
		"<br />"
		"<font color=\"blue\">" + selinux_customizable_types_path_str + "</font>"
		"<br />"
		"SELinux users path is"
		"<br />"
		"<font color=\"blue\">" + selinux_users_path_str + "</font>"
		"<br />"
		"SELinux userconf path is"
		"<br />"
		"<font color=\"blue\">" + selinux_usersconf_path_str + "</font>"
		"<br />"
		"SELinux translations path is"
		"<br />"
		"<font color=\"blue\">" + selinux_translations_path_str + "</font>"
		"<br />"
		"SELinux colors path is"
		"<br />"
		"<font color=\"blue\">" + selinux_colors_path_str + "</font>"
		"<br />"
		"SELinux netfilter context path is"
		"<br />"
		"<font color=\"blue\">" + selinux_netfilter_context_path_str + "</font>"
		"<br />"
		"SELinux path is"
		"<br />"
		"<font color=\"blue\">" + selinux_path_str + "</p>"));

        return 0;
}
/* returns selinux default enforce mode as QString*/
QString SegatexState::default_getenforcemode()
{
	/*I don't know why, but it returns ok.;)*/
	int tmp_value;
	tmp_value = 1;//enforcing
	//int *enforce;
	//enforce = &tmp_value;
	//selinux_getenforcemode(enforce);
	selinux_getenforcemode(&tmp_value);
	//if(*enforce == 1)
	if(*&tmp_value == 1)
		default_getenforcemode_str = tr("enforcing");
	//else if(*enforce == 0)
	else if(*&tmp_value == 0)
		default_getenforcemode_str = tr("permissive");
	//else if(*enforce == -1)
	else if(*&tmp_value == -1)
		default_getenforcemode_str = tr("disabled");

	return default_getenforcemode_str;
}

