/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "sesearch.h"
#include "sesearch_process.h"

#include <iostream>
using namespace std;

Sesearch::Sesearch(QWidget *parent, const char *name): QDialog(parent, name)
{
        sesearchLabel = new QLabel(tr("Information on"),this);
        expressionLabel = new QLabel(tr("[=NAME|=TYPE|=ADDR|=PORT]"),this);

        expressionEditLineEdit = new QLineEdit( this );
        expressionEditLineEdit->setText("");
        expressionEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	sesearchButton = new QPushButton(tr("See sesearch"), this);
	sesearchButton->setPaletteBackgroundColor(QColor(200,80,50));
	connect(sesearchButton, SIGNAL(clicked()), this, SLOT(sesearch_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QHBoxLayout;
	leftLayout = new QVBoxLayout;
	rightLayout = new QVBoxLayout;

	leftLayout->addWidget(sesearchLabel);
	leftLayout->addWidget(createFirstExclusiveGroup());
	rightLayout->addWidget(createFirstExclusiveGroup2());
	rightLayout->addWidget(expressionLabel);
	rightLayout->addWidget(expressionEditLineEdit);
	rightLayout->addStretch(5);
	rightLayout->addWidget(sesearchButton);
	rightLayout->addStretch(1);
	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);

	setLayout(mainLayout);
	setWindowTitle(tr("Sesearch"));

	sesearch_process = 0;
}
QGroupBox *Sesearch::createFirstExclusiveGroup2()
{
        optionButtonGroupBox2 = new QGroupBox(tr("OPTIONS"));
        expandCheckBox = new QCheckBox(tr("expand(show more info for specified components)"));
        statsCheckBox = new QCheckBox(tr("stats(print useful policy statistics)"));
        helpCheckBox = new QCheckBox(tr("help(show help)"));
        versionCheckBox = new QCheckBox(tr("version(show version)"));

        expandCheckBox->setChecked(true);

	vbox2 = new QVBoxLayout;
        vbox2->addWidget(expandCheckBox);
        vbox2->addWidget(statsCheckBox);
        vbox2->addWidget(helpCheckBox);
        vbox2->addWidget(versionCheckBox);
	optionButtonGroupBox2->setLayout(vbox2);

	return optionButtonGroupBox2;
}

QGroupBox *Sesearch::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("EXPRESSIONS"));
	//second,declear many buttons  
        allRadioButton = new QRadioButton(tr("all(print all below)"));
        classRadioButton = new QRadioButton(tr("class[=NAME]"));
        sensitivityRadioButton = new QRadioButton(tr("sensitivity[=NAME]"));
        categoryRadioButton = new QRadioButton(tr("category[=NAME]"));
        typeRadioButton = new QRadioButton(tr("type[=NAME]"));
        attributeRadioButton = new QRadioButton(tr("attribute[=NAME]"));
        roleRadioButton = new QRadioButton(tr("role[=NAME]"));
        userRadioButton = new QRadioButton(tr("user[=NAME]"));
        boolRadioButton = new QRadioButton(tr("bool[=NAME]"));
        initialsidRadioButton = new QRadioButton(tr("initialsid[=NAME]"));
        fs_useRadioButton = new QRadioButton(tr("fs_use[=TYPE]"));
        genfsconRadioButton = new QRadioButton(tr("genfscon[=TYPE]"));
        netifconRadioButton = new QRadioButton(tr("netifcon[=NAME]"));
        nodeconRadioButton = new QRadioButton(tr("nodecon[=ADDR]"));
        portconRadioButton = new QRadioButton(tr("portcon[=PORT]"));
 	 //--protocol=PROTO                 specify a protocol for portcons

        allRadioButton->setChecked(true);

	//third,add widget to vboxlayout
	vbox = new QVBoxLayout;
        vbox->addWidget(allRadioButton);
        vbox->addWidget(classRadioButton);
        vbox->addWidget(sensitivityRadioButton);
        vbox->addWidget(categoryRadioButton);
        vbox->addWidget(typeRadioButton);
        vbox->addWidget(attributeRadioButton);
        vbox->addWidget(roleRadioButton);
        vbox->addWidget(userRadioButton);
        vbox->addWidget(boolRadioButton);
        vbox->addWidget(initialsidRadioButton);
        vbox->addWidget(fs_useRadioButton);
        vbox->addWidget(genfsconRadioButton);
        vbox->addWidget(netifconRadioButton);
        vbox->addWidget(nodeconRadioButton);
        vbox->addWidget(portconRadioButton);
	optionButtonGroupBox->setLayout(vbox);
	
	return optionButtonGroupBox;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Sesearch::sesearch_button_clicked()
{
	if(allRadioButton->isChecked())
		sesearch_str_pp = "sesearch --all";
	if(classRadioButton->isChecked())
		sesearch_str_pp = "sesearch --class";
	if(sensitivityRadioButton->isChecked())
		sesearch_str_pp = "sesearch --sensitivity";
	if(categoryRadioButton->isChecked())
		sesearch_str_pp = "sesearch --category";
	if(typeRadioButton->isChecked())
		sesearch_str_pp = "sesearch --type";
	if(attributeRadioButton->isChecked())
		sesearch_str_pp = "sesearch --attribute";
	if(roleRadioButton->isChecked())
		sesearch_str_pp = "sesearch --role";
	if(userRadioButton->isChecked())
		sesearch_str_pp = "sesearch --user";
	if(boolRadioButton->isChecked())
		sesearch_str_pp = "sesearch --bool";
	if(initialsidRadioButton->isChecked())
		sesearch_str_pp = "sesearch --initialsid";
	if(fs_useRadioButton->isChecked())
		sesearch_str_pp = "sesearch --fs_use";
	if(genfsconRadioButton->isChecked())
		sesearch_str_pp = "sesearch --genfscon";
	if(netifconRadioButton->isChecked())
		sesearch_str_pp = "sesearch --netifcon";
	if(nodeconRadioButton->isChecked())
		sesearch_str_pp = "sesearch --nodecon";
	if(portconRadioButton->isChecked())
		sesearch_str_pp = "sesearch --portcon";


	//set expression name or etc.
	expressionEditLineEdit_str = expressionEditLineEdit->text();
	if(expressionEditLineEdit_str != ""){
		sesearch_str_pp = sesearch_str_pp + expressionEditLineEdit_str;
	}

	if(expandCheckBox->isChecked())
		sesearch_str_pp = sesearch_str_pp + " --expand";
	if(statsCheckBox->isChecked())
		sesearch_str_pp = sesearch_str_pp + " --stats";
	if(helpCheckBox->isChecked())
		sesearch_str_pp = sesearch_str_pp + " --help";
	if(versionCheckBox->isChecked())
		sesearch_str_pp = sesearch_str_pp + " --version";

	sesearch_str_pp_str = sesearch_str_pp;

	sesearch_process = new SesearchProcess(this);
	//connect(sesearch_process, SIGNAL(sesearch_process_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), sesearch_process, SLOT(close()));
	sesearch_process->setCaption(tr(sesearch_str_pp_str));
	sesearch_process->show();
	sesearch_process->raise();
	sesearch_process->setActiveWindow();

	sesearch_process->sesearch_base_process(sesearch_str_pp_str);

}
