/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <QLabel>
#include <Q3VBoxLayout>

#include "segatex_getseuserbyname.h"
#include "segatex_getseuserbyname_process.h"


//default constructor
SegatexGetseuserbyname::SegatexGetseuserbyname(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Getseuserbyname"));

	getseuserbynameLabel = new QLabel(tr("In F11, by default, you will get \n"
		"SELinux user unconfined_u and MLS/MCS level s0-s0:c0.c1023. \n"
		"So, even if you type non-existent user you will get the default. \n"
		"Fill in system_u, you will get system_u as SELinux user. \n"
		"If you mapped linux user to SELinux user with MLS/MCS, you will get a proper answer. \n"
		"You can do it with semanage login tab in segatex. \n"
		""), this );
	getseuserbynameLabel2 = new QLabel(tr("Fill in linux user."), this );

	getseuserbynameLineEdit = new QLineEdit( this );
	getseuserbynameLineEdit->setText("");
	getseuserbynameLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	getButton = new QPushButton(tr("get seuser and level"), this);
	getButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(getButton, SIGNAL(clicked()), this, SLOT(get_button_clicked()));
	closeButton = new QPushButton(tr("close"), this);
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new Q3VBoxLayout(this);
	leftLayout = new Q3HBoxLayout(this);
	rightLayout = new Q3HBoxLayout(this);

	mainLayout->setMargin(1);

	mainLayout->addWidget(getseuserbynameLabel);
	//leftLayout->addStretch(1);
	leftLayout->addWidget(getseuserbynameLabel2);
	leftLayout->addWidget(getseuserbynameLineEdit);
	rightLayout->addStretch(1);
	rightLayout->addWidget(getButton);
	rightLayout->addWidget(closeButton);
	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);
	//resize(300,300);
	segatex_getseuserbyname_process = 0;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SegatexGetseuserbyname::get_button_clicked()
{
	getseuserbynameLineEdit_str = getseuserbynameLineEdit->text();
	segatex_getseuserbyname_process = new SegatexGetseuserbynameProcess(this);
	segatex_getseuserbyname_process->segatex_getseuserbyname_base_process(getseuserbynameLineEdit_str);
}
