/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2012 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <q3textedit.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3HBoxLayout>
//#####################
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>

#include "segatex_yum.h"
#include "segatex_yum_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexYum::SegatexYum(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("Yum SELinux"));
		targetedCheckBox = new QCheckBox(tr("policy-targeted"), this);
		minimalCheckBox = new QCheckBox(tr("policy-minimal"), this);
		mlsCheckBox = new QCheckBox(tr("policy-mls"), this);
		targetedCheckBox->setChecked(true);
		minimalCheckBox->setChecked(true);
		mlsCheckBox->setChecked(true);
		//passwordLineEdit = new QLineEdit( this );
		//passwordLineEdit->setEchoMode(QLineEdit::Password);
		yumButton = new QPushButton(tr("&Install/Update"), this);
		closeButton = new QPushButton(tr("&Close"), this);
		yumButton->setDefault(true);

		connect(yumButton, SIGNAL(clicked()), this, SLOT(yum_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		Q3VBoxLayout *leftLayout = new Q3VBoxLayout;
		leftLayout->addWidget(targetedCheckBox);
		leftLayout->addWidget(minimalCheckBox);
		leftLayout->addWidget(mlsCheckBox);

		Q3VBoxLayout *rightLayout = new Q3VBoxLayout;
		//rightLayout->addWidget(passwordLineEdit);
		rightLayout->addWidget(yumButton);
		rightLayout->addWidget(closeButton);
		rightLayout->addStretch(1);

		Q3HBoxLayout *mainLayout = new Q3HBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(leftLayout);
		mainLayout->addLayout(rightLayout);
		//needs here to be declared
		selinux_yum_process = 0;
}
/*connects signal to close this window when yum process window's close button is clicked*/
void SegatexYum::yum_clicked()
{
	//if(!selinux_yum_process) {
		selinux_yum_process = new SegatexYumProcess(this);
		connect(selinux_yum_process, SIGNAL(yum_prosess_close_button_clicked()), this, SLOT(close()));
		connect(closeButton, SIGNAL(clicked()), selinux_yum_process, SLOT(close()));
	//}
	selinux_yum_process->show();
	selinux_yum_process->raise();
	selinux_yum_process->setActiveWindow();
}
/*unused*/
unsigned long  SegatexYum::getuid_uid_value()
{
	struct passwd *passwd; /* man getpwuid */
	unsigned long uid_value;
	passwd = getpwuid ( getuid()); /* Get the uid of the running processand use it to get a record from /etc/passwd */
	uid_value = (unsigned long) getpwuid(getuid())->pw_uid;
	/*
	printf("\n The Real User Name is %s ", passwd->pw_gecos);
	printf("\n The Login Name is %s ", passwd->pw_name);
	printf("\n The Home Directory is %s", passwd->pw_dir);
	printf("\n The Login Shell is %s ", passwd->pw_shell);
	printf("\n The Passwd is %s ", getpwuid(getuid()) >pw_passwd);
	printf("\n The uid is %lu ", (unsigned long) getpwuid(getuid())->pw_uid);
	printf("\n The gid is %lu \n\n", (unsigned long) getpwuid(getuid())->pw_gid);
	*/
	//cout << "getuid_uid_value" << uid_value << endl;

	return uid_value;
}
