/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEGATEXAUDIT2ALLOW_H
#define SEGATEXAUDIT2ALLOW_H

#include <qregexp.h>
#include <qdialog.h>
#include <qradiobutton.h>
#include <q3textedit.h>
#include <qlabel.h>
#include <qcheckbox.h>


class QLayout;
class Q3TextEdit;
class QLineEdit;
class QPushButton;
class Q3Process;
class SegatexAudit2allowProcess;

class SegatexAudit2allow: public QDialog
{
	Q_OBJECT
public:
	SegatexAudit2allow(QWidget *parent = 0, const char *name = 0);
	SegatexAudit2allowProcess *segatex_audit2allow_process;
	int j;
public slots:
signals:
	void explainChecked();
	void lastreloadChecked();
	void referenceChecked();
	void verboseChecked();
protected:

private slots:
	void audit2allow_clicked();
	unsigned long getuid_uid_value();//unused
private:
	QRadioButton *auditRadioButton;
	QRadioButton *dmesgRadioButton;
	QCheckBox *auditlogCheckBox;
	QCheckBox *messagesCheckBox;
	QCheckBox *lastreloadCheckBox;
	QCheckBox *requiresCheckBox;
	QCheckBox *referenceCheckBox;
	QCheckBox *verboseCheckBox;
	QCheckBox *explainCheckBox;
	QLabel *readfromLabel;
	QLabel *writetoLabel;
	QLabel *moduleNameLabel;
	QLabel *grepLabel;
	QLabel *optionLabel;
	QLineEdit *moduleNameLineEdit;
	QLineEdit *grepLineEdit;
	QString grepLineEdit_str;
	QLineEdit *writetoLineEdit;
	Q3TextEdit *textEdit1;
	QPushButton *audit2allowButton;
	QPushButton *closeButton;
	QString moduleName_str;
	QString outputfile_str;
	QString moduleName_str_caption;
	int log_file;
};

#endif
