/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qprocess.h>

#include "miscellaneous_process.h"

//#include <iostream>
//using namespace std;

MiscellaneousProcess::MiscellaneousProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	QVBoxLayout *headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	QHBoxLayout *footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(600,500);
}
void MiscellaneousProcess::close_button_clicked()
{
	emit audit2allow_prosess_close_button_clicked();

}
void MiscellaneousProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void MiscellaneousProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("audit2allow process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}

void MiscellaneousProcess::audit2allow_base_process(int log_file, QString outputfile_str, int g, QString moduleName_str)
{
	x = g / 1000;
	y = g % 1000;

	xx = g / 100;
	yy = g % 100;

	xxx= g / 10;
	yyy = g % 10;

	xxxx= g / 1;
	yyyy = g % 1;
	//devide by 1000  eq 1 and % eq 111 option -lRve
	//devide by 1000  eq 1 and % eq 110 option -lRv
	//devide by 1000  eq 1 and % eq 101 option -lRe
	//devide by 1000  eq 1 and % eq 100 option -lR
	//devide by 1000  eq 1 and % eq  11 option -lve
	//devide by 1000  eq 1 and % eq   1 option -le
	//devide by 1000  eq 1 and % eq  10 option -lv
	//devide by 1000  eq 1 and % eq   0 option -l
	//
	//devide by  100  eq 1 and % eq 11 option -Rve
	//devide by  100  eq 1 and % eq 10 option -Rv
	//devide by  100  eq 1 and % eq 1 option -Re
	//devide by  100  eq 1 and % eq 0 option -R
	//
	//devide by  10  eq 1 and % eq  1 option -ve
	//devide by  10  eq 1 and % eq  0 option -v
	//
	//devide by   1  eq 1 and % eq  0 option -e
	//devide by 1000  eq 0 and % eq   0 option -no_option

	this->setEnabled(false);
	process = new QProcess(this);
	process->addArgument("audit2allow");

	if((x == 1)&&(y == 111)){
		process->addArgument("-l");
		process->addArgument("-R");
		process->addArgument("-v");
		process->addArgument("-e");
		//cout << "lrve" << endl;
	}
	if((x == 1)&&(y == 110)){
		process->addArgument("-l");
		process->addArgument("-R");
		process->addArgument("-v");
		//cout << "lrv" << endl;
	}
	if((x == 1)&&(y == 101)){
		process->addArgument("-l");
		process->addArgument("-R");
		process->addArgument("-e");
		//cout << "lre" << endl;
	}
	if((x == 1)&&(y == 100)){
		process->addArgument("-l");
		process->addArgument("-R");
		//cout << "lr" << endl;
	}
	if((x == 1)&&(y == 11)){
		process->addArgument("-l");
		process->addArgument("-v");
		process->addArgument("-e");
		//cout << "lve" << endl;
	}
	if((x == 1)&&(y == 1)){
		process->addArgument("-l");
		process->addArgument("-e");
		//cout << "le" << endl;
	}
	if((x == 1)&&(y == 10)){
		process->addArgument("-l");
		process->addArgument("-v");
		//cout << "lv" << endl;
	}
	if((x == 1)&&(y == 0)){
		process->addArgument("-l");
		//cout << "l" << endl;
	}
	if((xx == 1)&&(yy == 11)){
		process->addArgument("-R");
		process->addArgument("-v");
		process->addArgument("-e");
		//cout << "rve" << endl;
	}
	if((xx == 1)&&(yy == 10)){
		process->addArgument("-R");
		process->addArgument("-v");
		//cout << "rv" << endl;
	}
	if((xx == 1)&&(yy == 1)){
		process->addArgument("-R");
		process->addArgument("-e");
		//cout << "re" << endl;
	}
	if((xx == 1)&&(yy == 0)){
		process->addArgument("-R");
		//cout << "r" << endl;
	}
	if((xxx == 1)&&(yyy == 1)){
		process->addArgument("-v");
		process->addArgument("-e");
		//cout << "ve" << endl;
	}
	if((xxx == 1)&&(yyy == 0)){
		process->addArgument("-v");
		//cout << "v" << endl;
	}
	if((xxxx == 1)&&(yyyy == 0)){
		process->addArgument("-e");
		//cout << "e" << endl;
	}
	if((x == 0)&&(y == 0)){
		//do nothing
		//cout << "nothing" << endl;
	}
	process->addArgument("-m");
	process->addArgument(moduleName_str);
	if(log_file == 3)
		process->addArgument("-a");
	if(log_file == 2){
		process->addArgument("-i");
		process->addArgument("/var/log/audit/audit.log");
	}
	if(log_file == 1){
		process->addArgument("-i");
		process->addArgument("/var/log/messages");
	}
	process->addArgument("-o");
	outputfile_str_common = outputfile_str;
	path = "/usr/share/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;
	process->addArgument(outputfile_str);
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	//read from .te file
	readFromOutputFile();
}

//this slot should be called from above slot
void MiscellaneousProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
		textEdit1->setCursorPosition(0,0);
}
