/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include "sqlrefpolicy.h"
#include "segatex_core2_process.h"

#include <iostream>
using namespace std;

//default constructor
SegatexCore2Process::SegatexCore2Process(QWidget *parent, const char *name): QDialog(parent, name)
{

	setCaption(tr("mypolicybysegatex"));
	textEdit1 = new Q3TextEdit(this);
	//textEdit1->setPaletteBackgroundColor(QColor(100,255,100));
	closeButton = new QPushButton(tr("close"), this);
//test
	nextDeniedMessageButton = new QPushButton(tr("&next Denied Message"), this);
	prevDeniedMessageButton = new QPushButton(tr("&prev Denied Message"), this);
	nextDeniedMessageButton->setPaletteBackgroundColor(QColor(155, 155, 255));
	prevDeniedMessageButton->setPaletteBackgroundColor(QColor(255, 155, 155));
//end-test

	closeButton->setDefault(true);

	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));
//test
	connect(nextDeniedMessageButton, SIGNAL(clicked()), this, SLOT(next_denied_message_button_clicked()));
	connect(prevDeniedMessageButton, SIGNAL(clicked()), this, SLOT(prev_denied_message_button_clicked()));
//end-test

	Q3VBoxLayout *headLayout = new Q3VBoxLayout;
	headLayout->addWidget(textEdit1);

	Q3HBoxLayout *footLayout = new Q3HBoxLayout;
	footLayout->addStretch(1);
//test
	footLayout->addWidget(prevDeniedMessageButton);
	footLayout->addWidget(nextDeniedMessageButton);
//end-test
	footLayout->addWidget(closeButton);

	Q3VBoxLayout *mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(700,500);

	segatex_core2_pre();

	sqlrefpolicy_select_o = 0;

}
void SegatexCore2Process::next_denied_message_button_clicked()
{
	emit segatex_core2_prosess_next_denied_message_button_clicked();

}
void SegatexCore2Process::prev_denied_message_button_clicked()
{
	emit segatex_core2_prosess_prev_denied_message_button_clicked();

}
void SegatexCore2Process::close_button_clicked()
{
	emit segatex_core2_prosess_close_button_clicked();

}
void SegatexCore2Process::segatex_core2_pre()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "/var/log/audit";
	path_to_be_written = "/usr/share/segatex/mypolicybysegatex_pre.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("audit.log");
	colon = ":";
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	while(it_d != files.end()){
		name = *it_d;
		file_interface_name = dir_name + forward_slash + name;
		QFile file( file_interface_name );
		if ( file.open( QIODevice::ReadOnly ) ) {
			Q3TextStream stream( &file );
			////////////////////////////////////////////
			lines.clear();
			line_analized.clear();
        		QStringList list2;
         		QString check_str;
         		QString av_str;
			int av_int;
			while ( !stream.atEnd() ) {
				line_analized = stream.readLine(); // line of text excluding '\n'
				if(line_analized.contains("Denied", Qt::CaseInsensitive)){
					//list2 = line_analized.split(" ");
					list2 = line_analized.split(" ", QString::SkipEmptyParts);	
					for (int i = 0; i < list2.size(); ++i){
          					check_str=list2.value(i);
  						if(check_str.startsWith("{")== true){
 							av_int = i+1;		
							log_str_access_vector=list2.value(av_int);
						}
  						if(check_str.startsWith("tclass")== true){
							log_str_tclass=list2.value(i);
							log_str_tclass = log_str_tclass.section('=', 1, 1);
						}
  						if(check_str.startsWith("tcontext")== true){
							log_str_tcontext=list2.value(i);
							log_str_tcontext = log_str_tcontext.section('=', 1, 1);
							log_str_tcontext = log_str_tcontext.section(':', 2, 2);
						}
  						if(check_str.startsWith("scontext")== true){
							log_str_scontext=list2.value(i);
							log_str_scontext = log_str_scontext.section('=', 1, 1);
							log_str_scontext = log_str_scontext.section(':', 2, 2);
						}
					}
					//lines += log_str_scontext + "," + log_str_tcontext + "," + log_str_tclass + "," + log_str_access_vector;
					lines += "Alert!! <font color=\"purple\">" + log_str_scontext + " </font> wants to <font color=\"red\"> " + log_str_access_vector + "  </font><font color=\"blue\"> " + log_str_tclass + " </font> in <font color=\"green\">" + log_str_tcontext + " </font> Refpolicy Analyzer will help you. <br />";

				}
			}
			//lines.removeDuplicates();
			//lines.sort();
		}
		file.close();
		++it_d;
	}
	//writing to file
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( QIODevice::WriteOnly | QIODevice::Append ) ) {
		Q3TextStream stream_w( &file_w );
		for ( it = lines.begin(); it != lines.end(); ++it ){
			//if(it == lines.begin())
				stream_w << *it;
			//else
			//	stream_w << endl << *it;
		}
	}
	file_w.close();
	//sqlrefpolicy_select(lines_log_str_scontext,lines_log_str_tcontext,lines_log_str_tclass,lines_log_str_access_vector);
	lines.clear();
	lines_log_str_scontext.clear();
	lines_log_str_tcontext.clear();
	lines_log_str_tclass.clear();
	lines_log_str_access_vector.clear();
	//writing to show
	if ( file_w.open( QIODevice::ReadOnly ) ) {
		Q3TextStream stream( &file_w );
		textEdit1->setText( stream.read() );
	}
	file_w.close();

}//end-segatex_core2_pre()
void SegatexCore2Process::sqlrefpolicy_select(const QList<QString> &l, const QList<QString> &l2, const QList<QString> &l3, const QList<QString> &l4)
{

	sqlrefpolicy_select_o = new Sqlrefpolicy(this);
        //you check this in next version
        //connect(segatex_core2_process_o, SIGNAL(segatex_core2_precess_next_denied_message_button_clicked()), this, SLOT(segatex_core2_next_denied_message_button_cliked()));
        connect(this, SIGNAL(segatex_core2_precess_next_denied_message_button_clicked()), sqlrefpolicy_select_o, SLOT(segatex_next_denied_message_button_cliked()));

	sqlrefpolicy_select_o->segatex_core2_process_sql(l,l2,l3,l4);
	sqlrefpolicy_select_o->show();
	sqlrefpolicy_select_o->raise();
}
