#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <process.h>
#include <signal.h>
#include <windows.h>

#ifndef STDERR_FILENO
#define STDERR_FILENO 2
#endif

/* More sensible support for subprocesses and sys/wait.h emulation.  */
static void
psignal (unsigned signo, char *msg)
{
  const char *p;
  const char hex_digits[] = "01234567890ABCDEF";
  char hex_buf[2*sizeof(signo) + 1];
  int i;

  /* Avoid *printf because they might be non-reentrant.  */
  for (p = msg; *p; p++);
  write (STDERR_FILENO, msg, p - msg);
  write (STDERR_FILENO, ": ", 2);

  memset (hex_buf, 0, sizeof hex_buf);
  switch (signo) {
    case STATUS_CONTROL_C_EXIT:
    case SIGINT:
    case SIGBREAK:
      p = "Keyboard interrupt";
      break;
    case SIGSEGV:
      p = "Segmentation fault";
      break;
    case STATUS_ACCESS_VIOLATION:
      p = "Access violation";
      break;
    case STATUS_INVALID_HANDLE:
      p = "Invalid or closed handle";
      break;
    case SIGILL:
    case STATUS_ILLEGAL_INSTRUCTION:
      p = "Illegal instruction";
      break;
    case STATUS_FLOAT_DIVIDE_BY_ZERO:
      p = "Floating divide by zero";
      break;
    case STATUS_INTEGER_DIVIDE_BY_ZERO:
      p = "Integer divide by zero";
      break;
    case STATUS_PRIVILEGED_INSTRUCTION:
      p = "Prividleged instruction";
      break;
    case STATUS_STACK_OVERFLOW:
      p = "Thread stack overflow";
      break;
    case STATUS_BREAKPOINT:
      p = "Breakpoint trap";
      break;
    case STATUS_SINGLE_STEP:
      p = "Trace trap";
      break;
    case STATUS_GUARD_PAGE_VIOLATION:
      p = "Guarded page access";
      break;
    case STATUS_DATATYPE_MISALIGNMENT:
      p = "Misaligned data access";
      break;
    case STATUS_IN_PAGE_ERROR:
      p = "Page fault";
      break;
    case STATUS_NO_MEMORY:
      p = "Memory exhausted";
      break;
    case STATUS_NONCONTINUABLE_EXCEPTION:
      p = "Attempt to continue from fatal exception";
      break;
    case STATUS_ARRAY_BOUNDS_EXCEEDED:
      p = "Array access out of bounds";
      break;
    case STATUS_FLOAT_DENORMAL_OPERAND:
      p = "Floating denormal operand";
      break;
    case STATUS_FLOAT_INEXACT_RESULT:
      p = "Floating inexact result";
      break;
    case SIGFPE:
    case STATUS_FLOAT_INVALID_OPERATION:
      p = "Arithmetic exception";
      break;
    case STATUS_FLOAT_OVERFLOW:
      p = "Floating overflow";
      break;
    case STATUS_FLOAT_STACK_CHECK:
      p = "Floating stack overflow/underflow";
      break;
    case STATUS_FLOAT_UNDERFLOW:
      p = "Floating underflow";
      break;
    case STATUS_INTEGER_OVERFLOW:
      p = "Integer overflow";
      break;
    case SIGTERM:
      p = "Terminated";
      break;
    case SIGABRT:
      p = "Aborted";
      break;
    default:
      p = "Unknown signal 0x";
      for (i = sizeof(hex_buf) - 2; i >= 0; i--)
	{
	  hex_buf[i] = hex_digits[signo & 15];
	  signo >>= 4;
	}
      break;
  }
  write (STDERR_FILENO, p, strlen (p));
  if (hex_buf[0])
    write (STDERR_FILENO, hex_buf, strlen (hex_buf));
  write (STDERR_FILENO, "\n", 1);
}

int main (int argc, char *argv[])
{
  char *args[] = {
    "junk", "tst4.exe",
    "-L\"rcs.c\t2006/04/18 17:21:50\t1.1\"",
    "-L\"rcs.c\t2006/04/18 17:26:02\"",
    "d:/usr/eli/utils/rcs-5.7.13/src/test/rcs.c,v",
    "test/rcs.c",
    NULL
  };
  unsigned ws = 0;
  int *wild = (int *)0xDEADBEEF;

  if (argc == 1)
    {
      printf ("argc = 1\n");
      signal (SIGINT, SIG_IGN);
      ws = spawnvp(P_WAIT, args[1], (const char * const *)(args+1));
      psignal (ws, "Subsidiary exit");
    }
  else
    {
#if 0
      printf ("SEGV: %d\n", *wild);
#endif
      printf ("Sleeping\n");
      SleepEx (10000, FALSE);
    }

  printf ("ret: %x\n", ws);
  return 0;
}
