/*-----------------------------------------------------------------------------
[]	BoxCharDefine.cpp
[Tv]	BOX\`ǗNX̎
[l]	Ȃ
[]	2003-02-10	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "shitarabian.h"
#include "BoxCharDefine.h"
#include "ExeCommon.h"
#include "Common.h"
#include "SettingPath.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CBoxCharDefine::CBoxCharDefine()
:	m_bEnabled( TRUE )
,	m_aItemz()
{
	TBoxChar	Item;

	// Sp
	Item.strChar = "@";
	Item.bEnable = FALSE;
	m_aItemz.Add( Item );

	// p
	Item.strChar = " ";
	Item.bEnable = FALSE;
	m_aItemz.Add( Item );

	// ^u
	Item.strChar = "\t";
	Item.bEnable = FALSE;
	m_aItemz.Add( Item );
}

/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CBoxCharDefine::~CBoxCharDefine()
{

}

/*-----------------------------------------------------------------------------
[]	iRs[j
[@\]	l̃Rs[B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CBoxCharDefine::Copy(
	CBoxCharDefine& SrcDefine	// I  :IuWFNg [-] (-) :-
)
{
	m_bEnabled = SrcDefine.GetEnable();
	m_aItemz.RemoveAll();
	m_aItemz.Append( SrcDefine.GetItemz() );
}

/*-----------------------------------------------------------------------------
[]	BOX\
[@\]	Cӂ̕BOX\ׂۂ߂B
[ߒl]	BOOL	BOX\ [-] (TRUE:BOX\AFALSE:BOX\łȂ)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CBoxCharDefine::IsBox(
	const char* pstrSrc		// I  :Ώە [-] (-) :-
)
{
	long	idxItem;
	if( GetEnable() )
	for( idxItem=0 ; idxItem<m_aItemz.GetSize() ; idxItem++ )
	if( m_aItemz[ idxItem ].bEnable )
	if( !m_aItemz[ idxItem ].strChar.IsEmpty() )
	{
		if (
			memcmp( pstrSrc, (LPCTSTR)m_aItemz[ idxItem ].strChar, m_aItemz[ idxItem ].strChar.GetLength() )
			== 0
		)
		{
			return( TRUE );
		}
	}
	return( FALSE );
}

/*-----------------------------------------------------------------------------
[]	t@Co
[@\]	t@Cւ̐ݒۑB
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CBoxCharDefine::Write()
{
	try
	{
		CString		strFilename = CSettingPath::GetInstance()->GetFolderPath() + "boxchar.ini";
		CStdioFile	file( strFilename, CFile::modeCreate | CFile::modeWrite );

		// o[W̏
		CString		strVersion;
		strVersion.LoadString( IDS_RELEASE_VERSION );
		file.WriteString( strVersion + "\n" );

		// L
		file.WriteString( BoolToString( m_bEnabled ) + "\n" );

		int	idxChar;
		for( idxChar=0 ; idxChar<m_aItemz.GetSize() ; idxChar++ )
		{
			CString	strChar;
			strChar.Format(
				"%s\n%s\n",
				BoolToString( m_aItemz[idxChar].bEnable ),
				QuoteString( m_aItemz[idxChar].strChar )
			);
			file.WriteString( strChar );
		}

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@Co", "CEmphasisDefine::Write()" );
		return( FALSE );
	}
}

/*-----------------------------------------------------------------------------
[]	t@Cǂݍ
[@\]	t@C̐ݒǍB
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CBoxCharDefine::Read()
{
	CString		strGeneralFilename = CSettingPath::GetInstance()->GetFolderPath() + "boxchar.ini";

	CFileStatus	status;
	BOOL	bExists = CFile::GetStatus( strGeneralFilename, status );
	if ( !bExists )
	{
		// t@Ĉ
		return( FALSE );
	}

	try
	{
		CStdioFile	file( strGeneralFilename, CFile::modeRead | CFile::shareDenyNone );

		BOOL	bSuccess = TRUE;

		// o[W̓ǂݍ
		CString		strVersion;
		bSuccess = file.ReadString( strVersion );
		if ( !bSuccess )
		{
			return( FALSE );
		}

		// L
		CString	strEnable;
		bSuccess = file.ReadString( strEnable );
		if ( !bSuccess )
		{
			return( FALSE );
		}
		m_bEnabled = StringToBool( strEnable );

		m_aItemz.RemoveAll();
		while( TRUE )
		{
			CString		strLine;

			TBoxChar	Item;
			bSuccess &= file.ReadString( strLine );
			Item.bEnable = StringToBool( strLine );

			bSuccess &= file.ReadString( strLine );
			Item.strChar = DeQuoteString( strLine );

			if ( bSuccess )
			{
				m_aItemz.Add( Item );
			}
			else
			{
				break;
			}
		}

		return( TRUE );
	}
	catch( CFileException* e )
	{
		e->Delete();
		ErrorLog( "t@C", "CBoxCharDefine::Read()" );
		return( FALSE );
	}

	return( TRUE );
}

