// RgL
// BregPool.h: CBregPool NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BREGPOOL_H__6EF8D474_9EF5_4F03_A5F5_A8287FBDBC8E__INCLUDED_)
#define AFX_BREGPOOL_H__6EF8D474_9EF5_4F03_A5F5_A8287FBDBC8E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BREGEXP.H"


typedef	int (* ProcMatch)(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
typedef	int (* ProcSubst)(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
typedef	int (* ProcTrans)(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
typedef	int (* ProcSplit)(char* regstr,char *target,char *targetendp, int limit,BREGEXP **rxp,char *msg); 
typedef	void (* ProcFree)(BREGEXP* rx); 
typedef	char* (* ProcVersion)(void);


class CBregPool  
{
private:
	// RXgN^
	CBregPool();

public:
	static CBregPool*	GetInstance();

	// fXgN^
	~CBregPool();

	// fXgN^Ă΂Free
	void DestroyFree();
	void Free(	BREGEXP*	rxp );

	// BREGEXP̍쐬
	BREGEXP* Get(char *regstr);


	BOOL LoadDll();
	BOOL FreeDll();

	BOOL	IsAlive(){ return( m_Dll != NULL ); };

	BOOL Match(
	char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg
	);
	BOOL Subst(
	char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg
	);

private:
	int m_nmax;
	BREGEXP **m_rxpool;

	HINSTANCE		m_Dll;
	ProcMatch		m_ProcMatch;
	ProcSubst		m_ProcSubst;
	ProcFree		m_ProcFree;
	ProcVersion		m_ProcVersion;
	/*
	int BMatch(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
	p^[}b`s܂BʂƃJbR()gp^[Ԃ܂B 
	int BSubst(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
	p^[ɂus܂Bup^[ƒu̕Ԃ܂B 
	int BTrans(char* regstr,char *target,char *targetendp, BREGEXP **rxp,char *msg) ; 
	ϊs܂Bϊƕϊ̕Ԃ܂B 
	int BSplit(char* regstr,char *target,char *targetendp, int limit,BREGEXP **rxp,char *msg); 
	p^[f~^ɂĕ𕪊܂B 
	void BRegfree(BREGEXP* rx); 
	RpCubNJ܂B 
	char* BRegexpVersion(void); 
	o[WԂ܂B 
	*/	

};

#endif // !defined(AFX_BREGPOOL_H__6EF8D474_9EF5_4F03_A5F5_A8287FBDBC8E__INCLUDED_)
