/*-----------------------------------------------------------------------------
[]	CommandInput.cpp
[Tv]	̓R}hNX̎
[l]	Ȃ
[]	2003-03-13	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "Shitarabian.h"
#include "ShitarabianDoc.h"
#include "CommandInput.h"
#include "CommandDelete.h"
#include "CommandCaret.h"
#include "ShitarabianPlugInManager.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCommandInput::CCommandInput():
	m_strInput(),			// ͂ꂽ [-] (-)
	m_idxStartRow( 0 ),		// ͂ꂽJnʒu [s] (-)
	m_idxStartColumn( 0 ),	// ͂ꂽJnʒu [] (-)
	m_idxEndRow( 0 ),		// ͂ꂽIʒu [s] (-)
	m_idxEndColumn( 0 )		// ͂ꂽIʒu [] (-)
{

}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCommandInput::~CCommandInput()
{

}


/*-----------------------------------------------------------------------------
[]	
[@\]	VCX^X𐶐ĕB
[ߒl]	ICommand*	ꂽCX^Xւ̃|C^ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
ICommand*	CCommandInput::Duplicate()
{
	ICommand*	pcmdNew;

	pcmdNew = new CCommandInput;
	pcmdNew->Copy( *this );

	return( pcmdNew );
}


/*-----------------------------------------------------------------------------
[]	Rs[
[@\]	Rs[B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void		CCommandInput::Copy(
	ICommand& cmdSrc		// I  :Rs[IuWFNg [-] (-) :-
)
{
	CCommandInput*	pInput;
	pInput = dynamic_cast<CCommandInput*>(&cmdSrc);

	if ( pInput != NULL )
	{
		m_strInput = pInput->m_strInput;			// ͂ꂽ [-] (-)
		m_idxStartRow = pInput->m_idxStartRow;		// ͂ꂽJnʒu [s] (-)
		m_idxStartColumn = pInput->m_idxStartColumn;// ͂ꂽJnʒu [] (-)
		m_idxEndRow = pInput->m_idxEndRow;			// ͂ꂽIʒu [s] (-)
		m_idxEndColumn = pInput->m_idxEndColumn;	// ͂ꂽIʒu [] (-)
	}
	else
	{
		// قȂ^̃Rs[悤Ƃ
		ASSERT( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	s
[@\]	̓R}hsB
[ߒl]	BOOL	 [-] (TURE:AFALSE:s)
[l]	SetAttribute()Ă邱ƁB
		P͂畡s͂܂őΉB
-----------------------------------------------------------------------------*/
BOOL		CCommandInput::Execute(
	CShitarabianDoc* pDoc		// I  :ΏۃhLg [-] (-) :-
)
{
	// sŐ؂ĕ񃊃Xg쐬A
	// XghLgInsertB

	// sŋ؂ăXg
	CStringList	lstAddz;
	CString		strDelimiter( pDoc->ReturnChar() );
	long	nLine;
	nLine = ::StringToList(
		m_strInput,
		&lstAddz,
		strDelimiter
	);

	// ̓f[^Ȃꍇ͏Ȃ
	if( nLine == 0)
	{
//		ASSERT( FALSE );
		return( TRUE );
	}

	// Insert
	{
		CString*		pstrLine;
		pstrLine = pDoc->GetLine( m_idxStartRow );

		// }Lbg̈ʒǔvZ
		CString&	strTail = lstAddz.GetTail();
		long iNewCaretPosition = ::ByteColumnToCaretColumn( strTail, strTail.GetLength() );

		if ( pstrLine != NULL )
		{
		// ݍs̔΂֑}鏈
			long		idxByte = ::CaretColumnToByteColumn( *pstrLine, m_idxStartColumn );

			// ݍs𕪊
			CString		strLeft = pstrLine->Left( idxByte );
			CString		strRight = pstrLine->Right( pstrLine->GetLength() - idxByte );

			// s܂łݍsɃ}[W
			CString&	strHead = lstAddz.GetHead();
			strHead.Insert( 0, strLeft );

			// Ō̍sɌݍs㔼}[W
			iNewCaretPosition = ::ByteColumnToCaretColumn( strTail, strTail.GetLength() );
			strTail += strRight;

		}

		// s̍XV
		{
			// ݍsf[g
			pDoc->DeleteLine( m_idxStartRow );
			// Xg֒ǉ
			pDoc->InsertLinez( m_idxStartRow, lstAddz );

			// XVʒm
			CShitarabianPlugInManager::GetInstance()->OnEdit(
				pDoc
			);
		}

		// Lbgʒu̐ݒ
		{
			m_idxEndRow = m_idxStartRow + nLine -1;
			m_idxEndColumn = iNewCaretPosition;
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( 0x00, m_idxEndRow, m_idxEndColumn );
			cmdCaret.Execute( pDoc );
		}

		// ĕ`XV
		if ( nLine == 1 )
		{
		// sύXȂ
			pDoc->SetUpdateStartRow( m_idxStartRow );
			pDoc->SetUpdateEndRow(m_idxStartRow );
		}
		else
		{
		// sύX
			pDoc->SetUpdateStartRow( m_idxStartRow );
			pDoc->SetUpdateEndRow( AllRow );
		}
		return( TRUE );
	}

	return( FALSE );
}


/*-----------------------------------------------------------------------------
[]	
[@\]	̓R}hB
[ߒl]	BOOL	 [-] (TURE:AFALSE:s)
[l]	Execute()Ă邱ƁB
-----------------------------------------------------------------------------*/
BOOL		CCommandInput::UnExecute(
	CShitarabianDoc* pDoc		// I  :ΏۃhLg [-] (-) :-
)
{
	// DeleteR}h𗘗pč폜
	CCommandDelete	cmdDelete;
	cmdDelete.SetAttribute(
		m_idxStartRow,
		m_idxStartColumn,
		m_idxEndRow,
		m_idxEndColumn
	);
	cmdDelete.Execute( pDoc );

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	ݒ
[@\]	CX^X̑ݒ肷B
[ߒl]	Ȃ
[l]	Execute()OɕKsĂƁB
-----------------------------------------------------------------------------*/
void		CCommandInput::SetAttribute(
	CString		strInput,		// I  :͂ꂽ [-] (-) :-
	long		idxRow,			// I  :͂ꂽʒu [s] (-) :-
	long		idxColumn		// I  :͂ꂽʒu [] (-) :-
)
{
	m_strInput = strInput;			// ͂ꂽ [-] (-)
	m_idxStartRow = idxRow;			// ͂ꂽʒu [s] (-)
	m_idxStartColumn = idxColumn;	// ͂ꂽʒu [] (-)

	// ȉUnExecutepBExecuteɗLȒlɐݒ肳
	m_idxEndRow = idxRow;			// ͂ꂽʒu [s] (-)
	m_idxEndColumn = idxColumn;		// ͂ꂽʒu [] (-)
}


