/*-----------------------------------------------------------------------------
[]	LogFont.cpp
[Tv]	tHgNX̎
[l]	Ȃ
[]	2002-12-12	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "LogFont.h"
#include "Common.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CLogFont::CLogFont()
:	m_iPointSize( 12 )
,	m_strFontName( "lr oSVbN" )
,	m_bBold( FALSE )
,	m_bItalic( FALSE )
,	m_bUnderLine( FALSE )
,	m_bStrikeOut( FALSE )
,	m_nCharSet( SHIFTJIS_CHARSET )
,	m_bFontCreate( FALSE )
{
}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CLogFont::~CLogFont()
{
	if ( m_bFontCreate )
	{
		m_fonText.DeleteObject( );
	}
}


/*-----------------------------------------------------------------------------
[]	LOGFONT\̎擾
[@\]	ݒ肳ꂽ񂩂LOGFONT\̂쐬A|C^߂B
[ߒl]	LOGFONT* LOGFONT\ [-] (-)
[l]	߂|C^͈ꎞIȂ́B
-----------------------------------------------------------------------------*/
LOGFONT*	CLogFont::GetLogFont(
	CDC*	pDC		// I: ΏDC [-] (-) :-
)
{
	memset( &m_tLogFont, 0x00, sizeof(LOGFONT) );

	m_tLogFont.lfHeight = -MulDiv(m_iPointSize, pDC->GetDeviceCaps(LOGPIXELSY), 72);

	memcpy( m_tLogFont.lfFaceName, (LPCTSTR)m_strFontName, m_strFontName.GetLength()+1  );

	if ( m_bBold )
	{
		m_tLogFont.lfWeight = FW_BOLD;
	}
	else
	{
		m_tLogFont.lfWeight = FW_REGULAR;
	}

	if ( m_bItalic )
	{
		m_tLogFont.lfItalic = TRUE;
	}
	else
	{
		m_tLogFont.lfItalic = FALSE;
	}

	if ( m_bUnderLine )
	{
		m_tLogFont.lfUnderline = TRUE;
	}
	else
	{
		m_tLogFont.lfUnderline = FALSE;
	}

	if ( m_bStrikeOut )
	{
		m_tLogFont.lfStrikeOut = TRUE;
	}
	else
	{
		m_tLogFont.lfStrikeOut = FALSE;
	}

	m_tLogFont.lfCharSet = m_nCharSet;

	return( &m_tLogFont );
}


/*-----------------------------------------------------------------------------
[]	CFont擾
[@\]	ݒ肳ꂽ񂩂CFont쐬A|C^߂B
[ߒl]	CFont* CFont|C^ [-] (-)
[l]	߂|C^͈ꎞIȂ́B
-----------------------------------------------------------------------------*/
CFont*	CLogFont::GetFont(
	CDC*	pDC		// I: ΏDC [-] (-) :-
)
{
	if ( m_bFontCreate )
	{
		m_fonText.DeleteObject( );
	}
	m_fonText.CreateFontIndirect( GetLogFont( pDC ) );
	m_bFontCreate = TRUE;

	return( &m_fonText );
}


/*-----------------------------------------------------------------------------
[]	t@Co
[@\]	ݒt@Cւ̏oB
[ߒl]	BOOL  [-] (TRUE:AFALSE:s)
[l]	Ini`B
-----------------------------------------------------------------------------*/
BOOL	CLogFont::Write(
	CString&		strFilename,
	const char*		strSection
)
{
	BOOL	bSuccess = TRUE;
	bSuccess &= WriteProfile( strFilename, strSection, "iPointSize",	LongToString( m_iPointSize ) );
	bSuccess &= WriteProfile( strFilename, strSection, "strFontName",	QuoteString( m_strFontName ) );
	bSuccess &= WriteProfile( strFilename, strSection, "strFontStyle",	QuoteString( m_strFontStyle ) );
	bSuccess &= WriteProfile( strFilename, strSection, "bBold",			BoolToString( m_bBold ) );
	bSuccess &= WriteProfile( strFilename, strSection, "bItalic",		BoolToString( m_bItalic ) );
	bSuccess &= WriteProfile( strFilename, strSection, "bUnderLine",	BoolToString( m_bUnderLine ) );
	bSuccess &= WriteProfile( strFilename, strSection, "bStrikeOut",	BoolToString( m_bStrikeOut ) );
	bSuccess &= WriteProfile( strFilename, strSection, "nCharSet",		LongToString( m_nCharSet ) );

	return( bSuccess );
}


/*-----------------------------------------------------------------------------
[]	t@Cǂݍ
[@\]	ݒt@C̓ǂݍ݁B
[ߒl]	BOOL  [-] (TRUE:AFALSE:s)
[l]	Ini`B
-----------------------------------------------------------------------------*/
BOOL	CLogFont::Read(
	CString&		strFilename,
	const char*		strSection
)
{
	BOOL		bSuccess;
	CString		strValue;

	bSuccess = ReadProfile( strFilename, strSection, "iPointSize", &strValue );
	if ( bSuccess ){ m_iPointSize = StringToLong( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "strFontName", &strValue );
	if ( bSuccess ){ m_strFontName = DeQuoteString( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "strFontStyle", &strValue );
	if ( bSuccess ){ m_strFontStyle = DeQuoteString( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "bBold", &strValue );
	if ( bSuccess ){ m_bBold = StringToBool( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "bItalic", &strValue );
	if ( bSuccess ){ m_bItalic = StringToBool( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "bUnderLine", &strValue );
	if ( bSuccess ){ m_bUnderLine = StringToBool( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "bStrikeOut", &strValue );
	if ( bSuccess ){ m_bStrikeOut = StringToBool( strValue ); }

	bSuccess = ReadProfile( strFilename, strSection, "nCharSet", &strValue );
	if ( bSuccess ){ m_nCharSet = (char)StringToLong( strValue ); }

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	l
[@\]	l̃Rs[B
[ߒl]	BOOL  [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CLogFont::Copy(
	const CLogFont&	fontSrc
)
{
	m_iPointSize = fontSrc.m_iPointSize;
	m_strFontName =	fontSrc.m_strFontName;
	m_strFontStyle = fontSrc.m_strFontStyle;
	m_bBold = fontSrc.m_bBold;
	m_bItalic =	fontSrc.m_bItalic;
	m_bUnderLine = fontSrc.m_bUnderLine;
	m_bStrikeOut = fontSrc.m_bStrikeOut;
	m_nCharSet = fontSrc.m_nCharSet;

	return( TRUE );
}