// RgL
// EditDrawer.cpp: CEditDrawer NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "EditDrawer.h"
#include "ShitarabianDoc.h"
#include <string.h>
#include "GeneralSetting.h"
#include "Selection.h"
#include "ROISelection.h"
#include "Common.h"
#include "resource.h"
#include "ShitarabianPlugInManager.h"
#include "ShitarabianPlugIn.h"
#include "Unicoder.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CString	CEditDrawer::m_strBlank( g_cstrSmallBlank );


CFont*	f_pOlDFont;
void CEditDrawer::ReflectFont( CDC* pDC )
{
	CFont*	pfonText;
	pfonText = CGeneralSetting::GetInstance()->GetLogFont()->GetFont( pDC );
	f_pOlDFont = pDC->SelectObject( pfonText );
}

void CEditDrawer::RestoreFont( CDC* pDC )
{
	pDC->SelectObject( f_pOlDFont );
}



//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CEditDrawer::CEditDrawer()
:	m_iZoom( 1 )
,	m_rcUpdate(0,0,0,0)
,	m_strEOF( "[EOF]" )
{
	RecalcFontSize();
}

CEditDrawer::~CEditDrawer()
{

}


CEditDrawer*	CEditDrawer::GetInstance()
{
	static CEditDrawer	sDrawer;

	return( &sDrawer );
}


long CEditDrawer::CaretRowToWindowPixelZoomed(
	long				iY
)
{
	long	lTopMargin;
	lTopMargin = CGeneralSetting::GetInstance()->GetTopMargin();

	return (
		CaretRowToPixel(
			iY
		)*m_iZoom + lTopMargin
	);
}


long CEditDrawer::PixelToCaretRow(
	long				iY,
	CShitarabianDoc*	pDoc
)
{
	// warning C4100:x̖
	pDoc;

	if ( iY < 0 )
	{
		return ( 0 );
	}

	long	iRow = iY/(( GetBlankHeight()+CGeneralSetting::GetInstance()->GetRowGap() ));

	return( iRow );
}

// Q̍sxsNZ
long CEditDrawer::CaretRowToPixel(
	long				iRow
)
{
	long	lPixelY = iRow * ( GetBlankHeight()+CGeneralSetting::GetInstance()->GetRowGap() );
	return( lPixelY );
}


//-----------------------------------------------------------------------------------
// [[\
void CEditDrawer::DrawRuler(
	CDC*			pDstDC,
	int				iDstX,
	int				iDstY
)
{
	if ( !CGeneralSetting::GetInstance()->GetVisibleRuler() )
	{
		return;
	}

	long	lLeftMargin;
	long	lTopMargin;
	lTopMargin = CGeneralSetting::GetInstance()->GetTopMargin();
	lLeftMargin = CGeneralSetting::GetInstance()->GetLeftMargin();

	int		lWidth = (m_rcUpdate.Width()/m_iZoom) +2;
	{
		COLORREF	colBack = ::GetBackColor( EMPHASIS_RULER );
		COLORREF	colText = ::GetForeColor( EMPHASIS_RULER );
		COLORREF	colLine = ::GetForeColor( EMPHASIS_RULER );

		CPen	penLine;
		penLine.CreatePen( PS_SOLID, 1, colLine );
		CPen*	pOldPen = pDstDC->SelectObject( &penLine );

		// hԂ
		pDstDC->FillSolidRect(
			0,
			0,
			lLeftMargin + iDstX + m_rcUpdate.Width(),
			iDstY + lTopMargin,
			colBack
		);

		// [̐`
		pDstDC->MoveTo(
			iDstX + lLeftMargin + 0,
			iDstY + lTopMargin-1
		);
		pDstDC->LineTo(
			iDstX + lLeftMargin + m_rcUpdate.Width(),
			iDstY + lTopMargin-1
		);

		// tHg̐ݒ
		CFont*	pfontOld = (CFont*)(pDstDC->SelectObject( CGeneralSetting::GetInstance()->GetRulerFont()->GetFont( pDstDC ) ) );

		pDstDC->SetTextColor( colText );
		pDstDC->SetBkMode( OPAQUE );

		// ڐ̕`
		int	iStep = 10;
		int	x = (iDstX/m_iZoom-lLeftMargin)/iStep*iStep;
		for( x ; x<iDstX/m_iZoom+lWidth ; x+=iStep )
		{
			if( x >= 0 )
			if( x%100 == 0 )
			{
				pDstDC->MoveTo(
					lLeftMargin +x*m_iZoom,
					iDstY + 0
				);
				pDstDC->LineTo(
					lLeftMargin +x*m_iZoom,
					iDstY + lTopMargin
				);
			}
			else if( x%50 == 0 )
			{
				pDstDC->MoveTo(
					lLeftMargin +x*m_iZoom,
					iDstY + lTopMargin/2-1
				);
				pDstDC->LineTo(
					lLeftMargin +x*m_iZoom,
					iDstY + lTopMargin-1
				);
			}
			else
			{
				pDstDC->MoveTo(
					lLeftMargin +x*m_iZoom,
					iDstY + lTopMargin*3/4-1
				);
				pDstDC->LineTo(
					lLeftMargin +x*m_iZoom,
					iDstY + lTopMargin-1
				);
			}
		}

		// ڐ̐`
		x = (iDstX/m_iZoom-lLeftMargin)/iStep*iStep;
		for( x ; x<iDstX/m_iZoom+lWidth ; x+=iStep )
		{
			if( x >= 0 )
			if( x%100 == 0 )
			{
				CString		strNumber;
				strNumber.Format("%d", x );

				CRect	rcText(
					lLeftMargin +x*m_iZoom +3,
					iDstY + 0,
					lLeftMargin +(x+100)*m_iZoom -1,
					iDstY + lTopMargin-1
				);
				pDstDC->DrawText(
					strNumber,
					rcText,
					DT_LEFT
				);
			}
		}

		// tHg̕A
		pDstDC->SelectObject( pfontOld );

		pDstDC->SelectObject( pOldPen );
	}
}


//-----------------------------------------------------------------------------------
// Ps\
// MEMDCɕ`sAg債DCփRs[
long CEditDrawer::DrawZoomedLine(
	CShitarabianDoc*	pDoc,
	CDC*				pDstDC,
	int					iRow,
	int					iScrollBoxLeft,
	int					iScrollBoxTop
)
{
/*
(1)Abvf[g`̃DC
(1-1)ǎ̕`
(1-2)Abvf[g`JnX̕炵ĕ`悷
	`͈͂̓NGXgiEBhEWHĵ
(2)DCo͐DCɓ]
(3)o͐DCɍ[ɍsԍ

_F
	m_rcUpdate XVv`ƂĎgpĂ邪
	ׂĂ̋ǖʂł SetUpdateRect() ݒ肵Ă̂^B
	ƂAĂȂ悤ȁH

	CEmphasisLine::Draw()ɃR[fBOG[`FbNꂽB
*/
	// Abvf[g`/Zoomi+jMemDC
	int		lWidth = (m_rcUpdate.Width()/m_iZoom) +2;
	int		lHeight = ( GetBlankHeight()+CGeneralSetting::GetInstance()->GetRowGap() );
	CDC			MemDC;
	MemDC.CreateCompatibleDC ( pDstDC );
	CBitmap		MemBitmap;
	MemBitmap.CreateCompatibleBitmap(
		pDstDC,
		lWidth,
		lHeight
	);
	CBitmap*	pOldBitmap = MemDC.SelectObject( &MemBitmap );

	COLORREF	colFore = ::GetForeColor( EMPHASIS_TEXT );
	COLORREF	colBack = ::GetBackColor( EMPHASIS_TEXT );

	long	lLeftMargin;
	long	lTopMargin;
	lTopMargin = CGeneralSetting::GetInstance()->GetTopMargin();
	lLeftMargin = CGeneralSetting::GetInstance()->GetLeftMargin();


	// wihԂ
	{
		MemDC.FillSolidRect(
			0,0,
			lWidth,
			lHeight,
			colBack
		);

		// rbg}bv]Ă݂
		{
			CShitarabianPlugInManager::GetInstance()->OnDrawWall(
				pDoc->GetInterface(),
				&MemDC,
				m_rcUpdate.left/m_iZoom,
				iScrollBoxTop/m_iZoom,
				lWidth,
				lHeight
			);
		}
	}

	// MemDCɕ`
	int	iMaxWidth = 0;
	{
		MemDC.SetBkMode( TRANSPARENT );
		SetDstX( -m_rcUpdate.left/m_iZoom );
		SetDstY( 0 );
		iMaxWidth = DrawPlaneLine(
			pDoc,
			&MemDC,
			iRow,
			TRUE
		);
	}

	// ROI``
	if( pDoc->GetOperationMode() == OperationROI )
	{
		CRect	rcROI = pDoc->GetROISelection()->GetROI();
		rcROI.NormalizeRect();
		if ( rcROI != CRect(0,0,0,0) )
		{
			rcROI.left		-= m_rcUpdate.left/m_iZoom;
			rcROI.right		-= m_rcUpdate.left/m_iZoom;
			rcROI.top		-= iScrollBoxTop/m_iZoom;
			rcROI.bottom	-= iScrollBoxTop/m_iZoom;
			MemDC.DrawFocusRect( rcROI );
		}
	}

	// w`
	if ( CGeneralSetting::GetInstance()->GetPrintDefine()->m_bPrintWidthLine )
	{
		int	iPrintWidth = CGeneralSetting::GetInstance()->GetPrintDefine()->m_lPrintPixelWidth;
		{
			CPen*	ppenOld;
			CPen	penWhite;
			penWhite.CreatePen( PS_SOLID, 1, colFore );
			CPen	penBlack;
			penBlack.CreatePen( PS_DOT, 1, colBack );

			long	lLeftX = (iPrintWidth) - m_rcUpdate.left/m_iZoom;
// DOT̐r؂Ȃ悤ɂ
			long	lOffsetY = (iRow*lHeight);

			ppenOld = MemDC.SelectObject( &penWhite );
			MemDC.MoveTo( lLeftX, 0 );
			MemDC.LineTo( lLeftX, lHeight );
			MemDC.SelectObject( &penBlack );
			MemDC.MoveTo( lLeftX, -lOffsetY );
			MemDC.LineTo( lLeftX, lHeight );
			MemDC.SelectObject( ppenOld );
		}
	}

	if ( 1 )
	{
		if ( m_iZoom == 1 )
		{
			// Dst֓]
			pDstDC->BitBlt(
				lLeftMargin + m_rcUpdate.left,
				lTopMargin + iScrollBoxTop,
				lWidth,
				lHeight,
				&MemDC,
				0,
				0,
				SRCCOPY
			);
		}
		else
		{
			// g債Dst֓]
			pDstDC->StretchBlt(
				lLeftMargin + (m_rcUpdate.left/m_iZoom)*m_iZoom,
				lTopMargin + iScrollBoxTop,
				lWidth*m_iZoom,
				lHeight*m_iZoom,
				&MemDC,
				0,
				0,
				lWidth,
				lHeight,
				SRCCOPY
			);
		}
	}
	MemDC.SelectObject( pOldBitmap );

	long	lLeftNumberMargin;
	lLeftNumberMargin = CGeneralSetting::GetInstance()->GetLeftNumberMargin();

	// ]hԂ
	pDstDC->FillSolidRect(
		iScrollBoxLeft,
		iScrollBoxTop+ lTopMargin,
		lLeftMargin,
		lHeight* m_iZoom,
		colBack
	);

	// sԍ\
	if ( iRow < pDoc->GetLineCount() )
	{
		// sԍ͈͓hԂ
		if ( CGeneralSetting::GetInstance()->GetVisibleNumber() )
		{
			colFore = ::GetForeColor( EMPHASIS_NUMBER );
			colBack = ::GetBackColor( EMPHASIS_NUMBER );

			// hԂ
			pDstDC->FillSolidRect(
				iScrollBoxLeft,
				iScrollBoxTop + lTopMargin,
				lLeftNumberMargin,
				lHeight*m_iZoom,
				colBack
			);
		}

		long	lLeftNumberMargin;
		lLeftNumberMargin = CGeneralSetting::GetInstance()->GetLeftNumberMargin();

		// }[Ns\
		if ( pDoc->IsMark( iRow ) )
		{
			colFore = ::GetForeColor( EMPHASIS_MARKED );
			colBack = ::GetBackColor( EMPHASIS_MARKED );
			pDstDC->FillSolidRect(
				iScrollBoxLeft,
				iScrollBoxTop + lTopMargin,
				iScrollBoxLeft + lLeftMargin,
				GetBlankHeight()*m_iZoom,
				colBack
			);
		}
		else
		// XVs\
		if ( CGeneralSetting::GetInstance()->GetVisibleNumber() )
		if ( pDoc->IsModify( iRow ) )
		{
			colFore = ::GetForeColor( EMPHASIS_MODIFIED );
			colBack = ::GetBackColor( EMPHASIS_MODIFIED );

			pDstDC->FillSolidRect(
				iScrollBoxLeft,
				iScrollBoxTop + lTopMargin,
				lLeftNumberMargin,
				GetBlankHeight()*m_iZoom,
				colBack
			);
		}

		// sԍ`
		if ( CGeneralSetting::GetInstance()->GetVisibleNumber() )
		{
			// tHg̐ݒ
			ReflectFont( pDstDC );

			CRect	rcNumber( 
				iScrollBoxLeft,
				iScrollBoxTop + lTopMargin,
				iScrollBoxLeft + lLeftNumberMargin-1,
				iScrollBoxTop + lTopMargin + GetBlankHeight()*m_iZoom-1 //lHeight*m_iZoom-1
			);
			CString		strNumber;
			strNumber.Format( "%06d ", iRow+1 );

			pDstDC->SetTextColor(
				colFore
			);
			pDstDC->DrawText(
				strNumber,
				rcNumber,
				DT_RIGHT | DT_VCENTER | DT_SINGLELINE
			);

			// tHg̕A
			RestoreFont( pDstDC );
		}
	}

	return( iMaxWidth * m_iZoom );
}


//-----------------------------------------------------------------------------------
// Ps\
long CEditDrawer::DrawPlaneLine(
	CShitarabianDoc*	pDoc,
	CDC*				pDstDC,
	int					iRow,
	BOOL				bCareSelection
)
{
	if ( iRow >= pDoc->GetLineCount() )
	{
		return( 0 );
	}

	CEmphasisLine*	pLine = pDoc->GetEmphasisLine( iRow );
	pLine->Draw(
		pDstDC,
		GetDstX(),
		GetDstY(),
		m_rcUpdate.left,
		m_rcUpdate.Width(),
		CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetEnable(),
		CGeneralSetting::GetInstance()->GetEmphasisDefine(),
		bCareSelection,
		pDoc,
		iRow
	);

	return( pLine->GetWidth() );
}

//-----------------------------------------------------------------------------------
// P\̈vZ
CSize CEditDrawer::ExtentCharactor(
	const char*		pstrSrc,
	CDC*			pDstDC,
	int*			pnPrintedByte,		// oCg
	int*			pnPrintedColumn,	// J
	int				iStartX				// \JnXWȋΈʒuj
)
{
	*pnPrintedByte = 0;
	*pnPrintedColumn = 0;

	if( *pstrSrc == 0x00 )
	{
		return( GetEOFWidth() );
	}

	// 
	{
		CUnicoder*	pUnicoder = CUnicoder::GetInstance();
		wchar_t		wcharUnicode;
		*pnPrintedByte = pUnicoder->IsUnicode(
			pstrSrc,
			&wcharUnicode
		);
		// UnicodełUnicode`
		if ( *pnPrintedByte > 0 )
		{
			CSize	sizeExtent;
			sizeExtent = pUnicoder->ExtextCharCode(
				pDstDC,
				wcharUnicode
			);
			*pnPrintedColumn = *pnPrintedByte;
			return( sizeExtent );
		}
	}

	// }`oCg
	int		iByteSize;
	if ( _istleadbyte( *pstrSrc ) != 0 )
	{
		iByteSize = 2;
	}
	else
	{
		iByteSize = 1;

		switch ( *pstrSrc )
		{
		case '\t':
			if ( !CGeneralSetting::GetInstance()->GetTabConvert() )
			{
				// ^uԊuvZ
				int		iWidth;
				{
					int	nTab = CGeneralSetting::GetInstance()->GetTabCount();
					long	iTabMark = GetBlankWidth() * nTab;
					long	lX = iStartX;
					iWidth = ((lX+iTabMark) / iTabMark) * iTabMark - lX;
				}

				*pnPrintedByte = iByteSize;
				*pnPrintedColumn = 1;
				CSize	sizeExtent;
				sizeExtent.cx = iWidth;
				sizeExtent.cy = GetBlankHeight();
				return( sizeExtent );
			}
			else
			{
				*pnPrintedByte = iByteSize;
				*pnPrintedColumn = 1;
				return( CSize(0,0) );
			}
			break;

		default:
			break;
		}
	}
	*pnPrintedByte = iByteSize;
	*pnPrintedColumn = 1;

	// gp̈vZ
	CSize	sizeExtent = pDstDC->GetTextExtent( pstrSrc, iByteSize );

	return( sizeExtent );
}


//-----------------------------------------------------------------------------------
// P\
void CEditDrawer::DrawCharactor(
	const char*		pstrSrc,
	CDC*			pDstDC,
	int*			pnPrintedByte,		// oCg
	int				iExtentChar,
	BOOL			bBox
)
{

	// 
	{
		CUnicoder*	pUnicoder = CUnicoder::GetInstance();
		wchar_t		wcharUnicode;
		*pnPrintedByte = pUnicoder->IsUnicode(
			pstrSrc,
			&(wcharUnicode)
		);
		// UnicodełUnicode`
		if ( *pnPrintedByte > 0 )
		{
			CRect	rcDst( GetDstX(), GetDstY(), GetDstX(), GetDstY() );
			pUnicoder->DrawCharCode(
				pDstDC,
				rcDst,
				wcharUnicode
			);
			return;
		}
	}

	DrawSJisCharactor(
		pstrSrc,
		pDstDC,
		pnPrintedByte,		// oCg
		iExtentChar,
		bBox
	);
}

void CEditDrawer::DrawSJisCharactor(
	const char*		pstrSrc,
	CDC*			pDstDC,
	int*			pnPrintedByte,		// oCg
	int				iExtentChar,
	BOOL			bBox
)
{
	BOOL	bDrawText = TRUE;

	// }`oCg
	int		iByteSize = 0;
	if ( _istleadbyte( *pstrSrc ) != 0 )
	{
		iByteSize = 2;
	}
	else
	{
		iByteSize = 1;
	}
	*pnPrintedByte = iByteSize;

	if ( bBox )
	{
		if ( iExtentChar > 0 )
		{
			// ``
			CPen	penDot( PS_DOT, 1, pDstDC->GetTextColor() );
			CRect	rcFrame(
				GetDstX(),
				GetDstY(),
				GetDstX() + iExtentChar- 1,
				GetDstY() + GetBlankHeight() -1
			);

			CPen*	ppenOld = pDstDC->SelectObject( &penDot );
			pDstDC->MoveTo( rcFrame.left, rcFrame.top+1 );
			pDstDC->LineTo( rcFrame.right-1,rcFrame.top+1 );
			pDstDC->LineTo( rcFrame.right-1,rcFrame.bottom-1 );
			pDstDC->LineTo( rcFrame.left, rcFrame.bottom-1 );
			pDstDC->LineTo( rcFrame.left, rcFrame.top+1 );
			pDstDC->SelectObject( ppenOld );
		}
	}
	else
	{
		if ( iByteSize == 1 )
		if( ((UCHAR)*pstrSrc) < 0x20 )
		{
			// Rg[R[h͕`悵Ȃ
			return;
		}

		if ( bDrawText )
		{
			// ̕`
			pDstDC->TextOut(
				GetDstX(),
				GetDstY(),
				pstrSrc,
				iByteSize
			);
		}
	}
}


long CEditDrawer::GetEOFWidth()
{
	return( m_iEOFWidth );
}
long CEditDrawer::GetBlankWidth()
{
	return( m_iBlankWidth );
}


long CEditDrawer::GetBlankHeight()
{
	return( m_iBlankHeight );
}


long CEditDrawer::GetCharWidth( CDC* pDC, CString str )
{
	long	lWidth;

	if ( pDC == NULL )
	{
		HDC		hdc = ::GetDC( NULL );
		CDC		DC;
		DC.Attach( hdc );

		ReflectFont( &DC );
		CSize	sizeExtent = DC.GetTextExtent( m_strBlank );
		RestoreFont( &DC );
		lWidth = sizeExtent.cx;

		DC.Detach();
		::ReleaseDC( NULL, hdc );
	}
	else
	{
		ReflectFont( pDC );
		CSize	sizeExtent = pDC->GetTextExtent( m_strBlank );
		RestoreFont( pDC );
		lWidth = sizeExtent.cx;
	}

	return( lWidth );
}




void CEditDrawer::RecalcFontSize()
{
	HDC		hdc = ::GetDC( NULL );
	CDC		DC;
	DC.Attach( hdc );
	ReflectFont( &DC );

	CSize	sizeExtent;
	sizeExtent = DC.GetTextExtent( m_strBlank );
	m_iBlankWidth = sizeExtent.cx;
	m_iBlankHeight = sizeExtent.cy;

	sizeExtent = DC.GetTextExtent( m_strEOF );
	m_iEOFWidth = sizeExtent.cx;

	RestoreFont( &DC );
	DC.Detach();
	::ReleaseDC( NULL, hdc );
}



// 񁨂wsNZ
long	CEditDrawer::StringToPixelX(
	const char*		pstrSrc,	//  [}`oCg] (-)
	CDC*			pDstDC
)
{
	ReflectFont( pDstDC );

	long	lSizeX = 0;

	SetDstX( 0 );
	while( *pstrSrc != '\0' )
	{
		int		iByteSize;
		int		iColumnSize;
		// gp̈vZ
		CSize	sizeExtent = ExtentCharactor(
			pstrSrc,
			pDstDC,
			&iByteSize,
			&iColumnSize,
			GetDstX()
		);
		lSizeX += sizeExtent.cx;

		SetDstX( GetDstX()+sizeExtent.cx );

		pstrSrc += iByteSize;
	}

	RestoreFont( pDstDC );

	return( lSizeX );
}

// xsNZQ̍s
long CEditDrawer::PixelToCaretRowZoomed(
	long				iY,
	CShitarabianDoc*	pDoc
){ return( PixelToCaretRow(iY/m_iZoom,pDoc) );};

long CEditDrawer::WindowPixelToCaretRowZoomed(
	long				iY,
	CShitarabianDoc*	pDoc
){

	long	lTopMargin;
	lTopMargin = CGeneralSetting::GetInstance()->GetTopMargin();
	int		iRow = PixelToCaretRow((iY-lTopMargin)/m_iZoom,pDoc);
	return( iRow );
};


// Q̍sxsNZ
long CEditDrawer::CaretRowToPixelZoomed(
	long				iRow
){ return( CaretRowToPixel(iRow)*m_iZoom );};



// StretchBlt()xB
// ǂ{̊giԂȂjȂ̂ŎOłĂ݂
void CEditDrawer::QuickStretchBlt(
	CBitmap*	pbmpSrc,
	CBitmap*	pbmpDst
)
{
	int		iZoom = m_iZoom;

	// Dst̂PC̃oCg擾
	BITMAP		tDstBitmap;
	pbmpDst->GetBitmap( &tDstBitmap );
	int			nDstLineByte = tDstBitmap.bmWidthBytes;

	// SrĉPC̃oCg擾
	BITMAP		tSrcBitmap;
	pbmpSrc->GetBitmap( &tSrcBitmap );
	int			nSrcLineByte = tSrcBitmap.bmWidthBytes;

	// F[x擾iDstASrcƂɓ͂j
	int		iDepth = (tSrcBitmap.bmBitsPixel+7)/8;

	// rbg}bvf[^擾
	int	nSrcByte = tSrcBitmap.bmBitsPixel*nSrcLineByte*tSrcBitmap.bmHeight;
	char*	pSrcBits = new char[ nSrcByte ];
	pbmpSrc->GetBitmapBits( nSrcByte, pSrcBits );
	int	nDstByte = tDstBitmap.bmBitsPixel*nDstLineByte*tDstBitmap.bmHeight;
	char*	pDstBits = new char[ nDstByte ];
	pbmpDst->GetBitmapBits( nDstByte, pDstBits );

	int		iHeight = min( tSrcBitmap.bmHeight, tDstBitmap.bmHeight/iZoom );
	int		iWidth = min( tSrcBitmap.bmWidth, tDstBitmap.bmWidth/iZoom );

	// s̃[v
	int			idxLine;
	int			iSrcOffsetLine = 0;
	int			iDstOffsetLine = 0;
	int			iSrcOffset = 0;
	int			iDstOffset = 0;
	for( idxLine=0 ; idxLine<iHeight; idxLine++ )
	{
	// CƂ̏
		iDstOffset = iDstOffsetLine;
		iSrcOffset = iSrcOffsetLine;

		// J̃[v
		int		idxColumn;
		for( idxColumn=0 ; idxColumn<iWidth ; idxColumn++ )
		{
			// g{]
			int		idxZoom;
			for( idxZoom=0 ; idxZoom<iZoom ; idxZoom++ )
			{
				int		idxDepth;
				for( idxDepth=0 ; idxDepth<iDepth ; idxDepth++ )
				{
					*( pDstBits+(iDstOffset++) ) = *( pSrcBits+iSrcOffset+idxDepth );
				}
			}
			iSrcOffset += iDepth;
		}

		// C]memcpy
		int		idxZoom;
		int		iDstOffsetLineStart = iDstOffsetLine;
		for( idxZoom=1 ; idxZoom<iZoom ; idxZoom++ )
		{
			iDstOffsetLine += nDstLineByte;
			memcpy( pDstBits+iDstOffsetLine, pDstBits+iDstOffsetLineStart, nDstLineByte );
		}

		iSrcOffsetLine += nSrcLineByte;
		iDstOffsetLine += nDstLineByte;
	}

	pbmpDst->SetBitmapBits( nDstByte, pDstBits );

	delete [] pDstBits;
	delete [] pSrcBits;
}





// ̕`
void CEditDrawer::DrawEOL(
	CDC*	pDstDC,
	BOOL	bEOF,
	BOOL	bSelected
)
{
	// EOF\
	if( bEOF )
	{
		if ( CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_EOF].GetEnable() )
		{
			COLORREF colFore = ::GetForeColor( EMPHASIS_EOF );

			pDstDC->SetTextColor( colFore );
			pDstDC->TextOut(
				GetDstX(),
				GetDstY(),
				m_strEOF,
				m_strEOF.GetLength()
			);
		}
	}
	else
	{
		// s\
		if ( CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_CRLF].GetEnable() )
		{
			COLORREF colFore = ::GetForeColor( EMPHASIS_CRLF );;
			COLORREF colBack = ::GetBackColor( EMPHASIS_CRLF );
			if( bSelected )
			{
				colFore = ::GetForeColor( EMPHASIS_SELECTED );
				colBack = ::GetBackColor( EMPHASIS_SELECTED );
			}

			int	iWidth = GetBlankWidth();
			int	iHeight = GetBlankHeight();

			CPen	penDot( PS_SOLID, 1, colFore );
			CPen*	ppenOld = pDstDC->SelectObject( &penDot );

			// c
			pDstDC->MoveTo( GetDstX()+iWidth*7/8, GetDstY()+iHeight*1/4 );
			pDstDC->LineTo( GetDstX()+iWidth*7/8, GetDstY()+iHeight*3/4 );

			// 
			pDstDC->LineTo( GetDstX()+iWidth*1/4-1, GetDstY()+iHeight*3/4 );

			// 
			pDstDC->MoveTo( GetDstX()+iWidth*2/4, GetDstY()+iHeight*5/8 );
			pDstDC->LineTo( GetDstX()+iWidth*1/4-1, GetDstY()+iHeight*3/4 );
			pDstDC->LineTo( GetDstX()+iWidth*2/4+1, GetDstY()+iHeight*7/8+1 );

			pDstDC->SelectObject( ppenOld );
		}
	}
}
