/*-----------------------------------------------------------------------------
[]	GeneralSetting.cpp
[Tv]	ݒNX̎
[l]	Ȃ
[]	2002-12-26	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "GeneralSetting.h"
#include "Common.h"
#include "ExeCommon.h"
#include "EditDrawer.h"
#include "MainFrm.h"
#include "SettingPath.h"
#include "BackUp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//-----------------------------------------------------------------------------
// t@C֐
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
// NX֐
//-----------------------------------------------------------------------------
/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CGeneralSetting::CGeneralSetting()
:	m_bTabConvert( FALSE )
,	m_nTab( 4 )
,	m_strTabString( _T("@@") )
,	m_bVisibleRuler( TRUE )
,	m_uiRulerHeight( 10 )
,	m_fontRuler()
,	m_uiRowGap( 2 )
,	m_iLeftNumberMargin( 60 )
,	m_iLeftBlankMargin( 8 )
,	m_eHScrollUnit( Scroll1Char )
,	m_eVScrollUnit( Scroll1Row )
,	m_bVisibleNumber( TRUE )
,	m_bBlockAlignment( FALSE )
,	m_uiWheelMove( 3 )
,	m_strQuote( ">" )
,	m_bFreeCursor( FALSE )
{
	// [tHg̐ݒ
	m_fontRuler.m_iPointSize = 8;

	// 󔒕̐ݒ
	{
		CArray<TWhiteSpace, TWhiteSpace&>*	pCharz;
		pCharz = GetWhitespace()->GetCharz();

		TWhiteSpace	tWhitespace;

		// Sp
		tWhitespace.bEnable = TRUE;
		tWhitespace.strChar = g_cstrBigBlank;
		tWhitespace.bCanContinuation = TRUE;	// A
		tWhitespace.bCanHead = TRUE;			// 擪
		tWhitespace.nCount = 0;					// pő
		pCharz->Add( tWhitespace );

		// p
		tWhitespace.bEnable = TRUE;
		tWhitespace.strChar = g_cstrSmallBlank;
		tWhitespace.bCanContinuation = FALSE;	// A
		tWhitespace.bCanHead = FALSE;			// 擪
		tWhitespace.nCount = 0;					// pő
		pCharz->Add( tWhitespace );

		// &nbsp;
		tWhitespace.bEnable = FALSE;
		tWhitespace.strChar = "&nbsp;";
		tWhitespace.bCanContinuation = TRUE;	// A
		tWhitespace.bCanHead = TRUE;			// 擪
		tWhitespace.nCount = 0;					// pő
		pCharz->Add( tWhitespace );

		// .
		tWhitespace.bEnable = FALSE;
		tWhitespace.strChar = _T(".");
		tWhitespace.bCanContinuation = TRUE;	// A
		tWhitespace.bCanHead = TRUE;			// 擪
		tWhitespace.nCount = 1;					// pő
		pCharz->Add( tWhitespace );
	}

	// E]
	m_Mirrorz.SetFilename("mirror.ini");
	{
		typedef struct {
			char*	pLeft;
			char*	pRight;
		} tmpFlip;
		const tmpFlip aFlip[] ={
			{ "", "" },
			{ "P", "Q" },
			{ "^","_" },
			{ "'","," },
			{ "","A_," },
			{ "","V" },
			{ "","" },
			{ "l","Y^" },
			{ "^","_" },
			{ "/","R" },
			{ "c","~" },
			{ ",","L" },
			{ "M","" },
		};

		for( int idxFlip=0 ; idxFlip<sizeof(aFlip)/sizeof(tmpFlip) ; idxFlip++ )
		{
			TFlip	tFlip;
			tFlip.strLeft = aFlip[idxFlip].pLeft;
			tFlip.strRight = aFlip[idxFlip].pRight;

			m_Flipz.GetFliperz()->Add( tFlip );
		}
	}

	// ㉺]
	m_Flipz.SetFilename("flip.ini");
	{
		typedef struct {
			char*	pLeft;
			char*	pRight;
		} tmpMirror;
		const tmpMirror aMirror[] ={
			{ "(", ")" },
			{ "<", ">" },
			{ "[","]" },
			{ "","" },
			{ "i","j" },
			{ "o","p" },
			{ "{","}" },
			{ "","" },
			{ "^","_" },
			{ "/","R" },
			{ "c","~" },
			{ "s","t" },
			{ "q","r" },
			{ "","" },
			{ "M","L" },
		};

		for( int idxMirror=0 ; idxMirror<sizeof(aMirror)/sizeof(tmpMirror) ; idxMirror++ )
		{
			TFlip	tMirror;
			tMirror.strLeft = aMirror[idxMirror].pLeft;
			tMirror.strRight = aMirror[idxMirror].pRight;

			m_Mirrorz.GetFliperz()->Add( tMirror );
		}
	}
}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CGeneralSetting::~CGeneralSetting()
{
}


/*-----------------------------------------------------------------------------
[]	BCX^X̎擾
[@\]	singletonp^[ɂBCX^X̊mۂƎ擾B
[ߒl]	CGeneralSetting*
			CGeneralSetting IuWFNg̗BCX^X [-] (-)
[l]	singletonp^[B
-----------------------------------------------------------------------------*/
CGeneralSetting*	CGeneralSetting::GetInstance()
{
	static CGeneralSetting	Instance;
	static BOOL	bInitialize = FALSE;
	if ( !bInitialize )
	{
		bInitialize = TRUE;

		// t@C̓ǂݍ
		Instance.Read();
	}
	return( &Instance );
}

/*-----------------------------------------------------------------------------
[]	[]̎擾
[@\]	sԍ\܂ލ[]擾B
[ߒl]	int
			[] [Pixel] (-)
[l]	sԍ̗Lɂ蕝قȂB
-----------------------------------------------------------------------------*/
int		CGeneralSetting::GetLeftMargin()
{
	if ( GetVisibleNumber() )
	{
		return( m_iLeftNumberMargin + m_iLeftBlankMargin );
	}
	else
	{
		return( m_iLeftBlankMargin );
	}
}

/*-----------------------------------------------------------------------------
[]	[]̎擾
[@\]	[\܂ޏ[]擾B
[ߒl]	int
			[] [Pixel] (-)
[l]	[̗Lɂ荂قȂB
-----------------------------------------------------------------------------*/
int		CGeneralSetting::GetTopMargin()
{
	if ( GetVisibleRuler() )
	{
		return( m_uiRulerHeight );
	}
	else
	{
		return( 0 );
	}
}

/*-----------------------------------------------------------------------------
[]	t@C
[@\]	t@Cւ̏ݏsB
[ߒl]	BOOL
			 [-] (TRUE:AFALSE:s)
[l]	t@Ĉ͌߂BtH_ ::IniFilePath() ɂĎ擾łtH_B
-----------------------------------------------------------------------------*/
BOOL	CGeneralSetting::Write()
{
	BOOL	bSuccess = TRUE;

// ݒނƂɕۑ͎̂wtH_ɏo
	{
		CString		strGeneralFilename = CSettingPath::GetInstance()->GetFolderPath() + "typegeneral.ini";

		// o[W̏
		CString		strVersion;
		strVersion.LoadString( IDS_RELEASE_VERSION );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "Version",				strVersion );

		// ̏o
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "strSettingName",		QuoteString( m_strSettingName ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "strExt",				QuoteString( m_strExt ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bTabConvert",			BoolToString( m_bTabConvert ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "strTabString",		QuoteString( m_strTabString ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "nTab",				LongToString( m_nTab ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "uiRowGap",			LongToString( m_uiRowGap ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "iLeftNumberMargin",	LongToString( m_iLeftNumberMargin ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "iLeftBlankMargin",	LongToString( m_iLeftBlankMargin ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bVisibleNumber",		BoolToString( m_bVisibleNumber ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "uiRulerHeight",		LongToString( m_uiRulerHeight ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bVisibleRuler",		BoolToString( m_bVisibleRuler ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bFreeCursor",			BoolToString( m_bFreeCursor ) );

		bSuccess &= m_LogFont.Write( strGeneralFilename, "Font" );
		bSuccess &= m_fontRuler.Write( strGeneralFilename, "RulerFont" );
		bSuccess &= m_Whitespace.Write();
		bSuccess &= m_EmphasisDefine.Write();
		bSuccess &= m_PrintDefine.Write( strGeneralFilename );
		bSuccess &= m_BoxCharDefine.Write();
	}

// ʐݒ͂тtH_ɏo
	{
		CString		strGeneralFilename = CSettingPath::GetInstance()->GetShitarabianFolderPath() + "commongeneral.ini";

		// o[W̏
		CString		strVersion;
		strVersion.LoadString( IDS_RELEASE_VERSION );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "Version",				strVersion );

		// ̏o
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bOneShotBOXSelect",	BoolToString( m_bOneShotBOXSelect ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "eHScrollUnit",		EScrollUnitToString( m_eHScrollUnit ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "eVScrollUnit",		EScrollUnitToString( m_eVScrollUnit ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bBlockAlignment",		BoolToString( m_bBlockAlignment ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "uiWheelMove",			LongToString( m_uiWheelMove ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "strQuote",			QuoteString( m_strQuote ) );
		bSuccess &= m_Flipz.Write();
		bSuccess &= m_Mirrorz.Write();

		// Q
		int		idxLoop;
		for( idxLoop=0 ; idxLoop<m_aSubStringz.GetSize() ; idxLoop++ )
		{
			CString		strKey;
			strKey.Format( "strSubString%d", idxLoop );
			bSuccess &= WriteGeneralProfile(
				strGeneralFilename,
				strKey,
				m_aSubStringz[idxLoop]
			);
		}

		// uQ
		for( idxLoop=0 ; idxLoop<m_aReplaceStringz.GetSize() ; idxLoop++ )
		{
			CString		strKey;
			strKey.Format( "strReplaceString%d", idxLoop );
			bSuccess &= WriteGeneralProfile(
				strGeneralFilename,
				strKey,
				m_aReplaceStringz[idxLoop]
			);
		}

		// Eu
		::GetMainFrame()->m_dlgFinder.UpdateData( TRUE );
		::GetMainFrame()->m_dlgReplacer.UpdateData( TRUE );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bFindCareCase",	BoolToString( ::GetMainFrame()->m_dlgFinder.m_bCaseCare ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bFindLoop",	BoolToString( ::GetMainFrame()->m_dlgFinder.m_bLoop ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bFindToken",	BoolToString( ::GetMainFrame()->m_dlgFinder.m_bToken ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bFindRegExp",	BoolToString( ::GetMainFrame()->m_dlgFinder.m_bRegExp ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bReplaceCareCase",	BoolToString( ::GetMainFrame()->m_dlgReplacer.m_bCaseCare ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bReplaceLoop",	BoolToString( ::GetMainFrame()->m_dlgReplacer.m_bLoop ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bReplaceToken",	BoolToString( ::GetMainFrame()->m_dlgReplacer.m_bToken ) );
		bSuccess &= WriteGeneralProfile( strGeneralFilename, "bReplaceRegExp",	BoolToString( ::GetMainFrame()->m_dlgReplacer.m_bRegExp ) );

		bSuccess &= CBackUp::GetInstance()->Write( strGeneralFilename );
	}

	return( bSuccess );
}

/*-----------------------------------------------------------------------------
[]	t@Cǂݍ
[@\]	t@C̓ǂݍݏsB
[ߒl]	BOOL
			 [-] (TRUE:AFALSE:s)
[l]	t@Ĉ͌߂BtH_ ::IniFilePath() ɂĎ擾łtH_B
-----------------------------------------------------------------------------*/
BOOL	CGeneralSetting::Read()
{
	BOOL		bSuccess;

// ݒނƂɕۑ͎̂wtH_ǂ
	{
		CString		strGeneralFilename = CSettingPath::GetInstance()->GetFolderPath() + "typegeneral.ini";

		// o[W̓ǂݍ
		CString		strVersion;
		bSuccess = ReadGeneralProfile( strGeneralFilename, "Version", &strVersion );
		if ( bSuccess )
		{
			// ̓ǂݍ
			CString		strValue;

			bSuccess = ReadGeneralProfile( strGeneralFilename, "strSettingName", &strValue );
			if ( bSuccess ){ m_strSettingName	= DeQuoteString( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "strExt", &strValue );
			if ( bSuccess ){ m_strExt	= DeQuoteString( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bTabConvert", &strValue );
			if ( bSuccess ){ m_bTabConvert	= StringToBool( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "strTabString", &strValue );
			if ( bSuccess ){ m_strTabString	= DeQuoteString( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "nTab", &strValue );
			if ( bSuccess ){ m_nTab	= StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "uiRowGap", &strValue );
			if ( bSuccess ){ m_uiRowGap	= StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "iLeftNumberMargin", &strValue );
			if ( bSuccess ){ m_iLeftNumberMargin	= StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "iLeftBlankMargin", &strValue );
			if ( bSuccess ){ m_iLeftBlankMargin	= StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bVisibleNumber", &strValue );
			if ( bSuccess ){ m_bVisibleNumber	= StringToBool( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "uiRulerHeight", &strValue );
			if ( bSuccess ){ m_uiRulerHeight = StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bVisibleRuler", &strValue );
			if ( bSuccess ){ m_bVisibleRuler = StringToBool( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bFreeCursor", &strValue );
			if ( bSuccess ){ m_bFreeCursor = StringToBool( strValue ); }
		}

		m_LogFont.Read( strGeneralFilename, "Font" );
		m_fontRuler.Read( strGeneralFilename, "RulerFont" );
		m_Whitespace.Read();
		m_EmphasisDefine.Read();
		m_PrintDefine.Read( strGeneralFilename );
		m_BoxCharDefine.Read();
	}

// ʐݒ͂тtH_ǂ
	{
		CString		strGeneralFilename = CSettingPath::GetInstance()->GetShitarabianFolderPath() + "commongeneral.ini";

		// o[W̓ǂݍ
		CString		strVersion;
		bSuccess = ReadGeneralProfile( strGeneralFilename, "Version", &strVersion );
		if ( bSuccess )
		{
			// ̓ǂݍ
			CString		strValue;

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bOneShotBOXSelect", &strValue );
			if ( bSuccess ){ m_bOneShotBOXSelect	= StringToBool( strValue ); }


			bSuccess = ReadGeneralProfile( strGeneralFilename, "eHScrollUnit", &strValue );
			if ( bSuccess ){ m_eHScrollUnit	= StringToEScrollUnit( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "eVScrollUnit", &strValue );
			if ( bSuccess ){ m_eVScrollUnit	= StringToEScrollUnit( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bBlockAlignment", &strValue );
			if ( bSuccess ){ m_bBlockAlignment = StringToBool( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "uiWheelMove", &strValue );
			if ( bSuccess ){ m_uiWheelMove	= StringToLong( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "strQuote", &strValue );
			if ( bSuccess ){ m_strQuote	= DeQuoteString( strValue ); }

			// Q
			int		idxLoop;
			bSuccess = TRUE;
			m_aSubStringz.RemoveAll();
			for( idxLoop=0 ; bSuccess ; idxLoop++ )
			{
				CString		strKey;
				strKey.Format( "strSubString%d", idxLoop );
				bSuccess = ReadGeneralProfile(
					strGeneralFilename,
					strKey,
					&strValue
				);
				if ( bSuccess )
				{
					::GetMainFrame()->AddSubString( strValue, NULL );
				}
			}

			// uQ
			bSuccess = TRUE;
			m_aReplaceStringz.RemoveAll();
			for( idxLoop=0 ; bSuccess ; idxLoop++ )
			{
				CString		strKey;
				strKey.Format( "strReplaceString%d", idxLoop );
				bSuccess = ReadGeneralProfile(
					strGeneralFilename,
					strKey,
					&strValue
				);
				if ( bSuccess )
				{
					::GetMainFrame()->AddReplaceString( strValue, NULL );
				}
			}

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bFindCareCase", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgFinder.m_bCaseCare = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bFindLoop", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgFinder.m_bLoop = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bFindToken", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgFinder.m_bToken = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bFindRegExp", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgFinder.m_bRegExp = StringToBool( strValue ); }

			bSuccess = ReadGeneralProfile( strGeneralFilename, "bReplaceCareCase", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgReplacer.m_bCaseCare = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bReplaceLoop", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgReplacer.m_bLoop = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bReplaceToken", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgReplacer.m_bToken = StringToBool( strValue ); }
			bSuccess = ReadGeneralProfile( strGeneralFilename, "bReplaceRegExp", &strValue );
			if ( bSuccess ){ ::GetMainFrame()->m_dlgReplacer.m_bRegExp = StringToBool( strValue ); }

			::GetMainFrame()->m_dlgFinder.UpdateData( FALSE );
			::GetMainFrame()->m_dlgReplacer.UpdateData( FALSE );
		}

		m_Flipz.Read();
		m_Mirrorz.Read();
		CBackUp::GetInstance()->Read( strGeneralFilename );
	}
	return( TRUE );
}
