// Setting.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "shitarabianLogic.h"
#include "Setting.h"
#include "ShitarabianLogicImp.h"
#include "DocumentIF.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MATRIXNUM		( 40 )				//}gbNX̐
#define PREVIEWSIZE		( 150 )				//vr[̕

/////////////////////////////////////////////////////////////////////////////
// CSetting _CAO


CSetting::CSetting(CWnd* pParent /*=NULL*/)
	: CDialog(CSetting::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetting)
	m_bEnable = FALSE;
	m_iMatrixNumY = 0;
	m_iMatrixNumX = 0;
	m_strPreviewX = _T("");
	m_strPreviewY = _T("");
	//}}AFX_DATA_INIT
}


void CSetting::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetting)
	DDX_Control(pDX, IDC_PREVIEW, m_PreView);
	DDX_Control(pDX, IDC_SLIDERY, m_ctrSliderY);
	DDX_Control(pDX, IDC_SLIDERX, m_ctrSliderX);
	DDX_Check(pDX, IDC_ENABLE, m_bEnable);
	DDX_Slider(pDX, IDC_SLIDERY, m_iMatrixNumY);
	DDX_Slider(pDX, IDC_SLIDERX, m_iMatrixNumX);
	DDX_Text(pDX, IDC_STATICX, m_strPreviewX);
	DDX_Text(pDX, IDC_STATICY, m_strPreviewY);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetting, CDialog)
	//{{AFX_MSG_MAP(CSetting)
	ON_BN_CLICKED(IDC_OK, OnOk)
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_BMPOPEN, OnBmpopen)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_EXPORT, OnExport)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_CANCEL, OnCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetting bZ[W nh

void CSetting::OnOk() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData( TRUE );
	CDialog::OnOK();
}

void CSetting::OnCancel() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CDialog::OnCancel();
}

void CSetting::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	UpdateData( FALSE );
}

BOOL CSetting::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_pBitmap = NULL;

	//XC_[X̐ݒ
	m_ctrSliderX.SetRangeMin( 0 , FALSE );
	m_ctrSliderX.SetRangeMax( MATRIXNUM , FALSE );
	m_ctrSliderX.SetPos( MATRIXNUM / 2 );
	m_ctrSliderX.SetTicFreq( MATRIXNUM / 4 );

	//XC_[Y̐ݒ
	m_ctrSliderY.SetRangeMin( 0 , FALSE );
	m_ctrSliderY.SetRangeMax( MATRIXNUM , FALSE );
	m_ctrSliderY.SetPos( MATRIXNUM / 2 );
	m_ctrSliderY.SetTicFreq( MATRIXNUM / 4 );

	UpdateData( TRUE );

	//XC_[̐
	m_strPreviewX.Format( "X : %d" , m_iMatrixNumX );
	m_strPreviewY.Format( "Y : %d" , m_iMatrixNumY );

	//vr[\ʒu
	CPoint ptFrame( 0,0 );
	m_PreView.ClientToScreen( &ptFrame );
	CPoint ptDialog( 0,0 );
	ClientToScreen( &ptDialog );
	m_iPrevPosX	= ptFrame.x - ptDialog.x;
	m_iPrevPosY = ptFrame.y - ptDialog.y;
	
	//vr[̃[W쐬
	m_rectPreview.left		= m_iPrevPosX;
	m_rectPreview.top		= m_iPrevPosY;
	m_rectPreview.right		= m_iPrevPosX + PREVIEWSIZE;
	m_rectPreview.bottom	= m_iPrevPosY + PREVIEWSIZE;

	//o̓{^̎gp
	GetDlgItem( IDC_EXPORT )->EnableWindow( FALSE );

	UpdateData( FALSE );
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

//Qƃ{^
void CSetting::OnBmpopen() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CFileDialog fd(
		TRUE,									//t@CJ
		"bmp",									//gq
		"*.bmp",								//t@C̖Oi\L̖Oj
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		"rbg}bv",							//t@C̎
		NULL );

	if ( fd.DoModal() == IDOK )
	{
		m_strFilePassName = fd.GetPathName();	//t@CpX擾
		
		//rbg}bv荞ł
		HBITMAP		hBitmap;

		hBitmap = ( HBITMAP ) ::LoadImage(
			NULL,
			m_strFilePassName,
			IMAGE_BITMAP,
			0,0,
			LR_LOADFROMFILE | LR_MONOCHROME
			);

		m_pBitmap = CBitmap::FromHandle( hBitmap );

		DrawPreview();
		GetDlgItem( IDC_EXPORT )->EnableWindow( TRUE );
	}
}

//t@C_CAOɕ\
void CSetting::DrawPreview()
{
	UpdateData( TRUE );
	if ( m_pBitmap == NULL )
	{
		return;
	}	
	//vr[傫
	int iPreViewWidth	= GetPreviewSize( m_iMatrixNumX );
	int iPreViewHeight	= GetPreviewSize( m_iMatrixNumY );

	CClientDC	dcDlg( this );
	CDC			dcPreview;
	CDC			dcMatrix;
	CBitmap		bmpMatrix;

	bmpMatrix.CreateCompatibleBitmap(
		&dcDlg,
		m_iMatrixNumX,
		m_iMatrixNumY
		);
	
	m_pBitmap->GetBitmap( &m_tBitmap );

	dcPreview.CreateCompatibleDC( &dcDlg );
	dcMatrix.CreateCompatibleDC( &dcPreview );

	dcMatrix.SelectObject( &bmpMatrix );
	dcPreview.SelectObject( m_pBitmap );

	dcMatrix.StretchBlt(
		0,0,
		m_iMatrixNumX,m_iMatrixNumY,
		&dcPreview,
		0,0,
		m_tBitmap.bmWidth,m_tBitmap.bmHeight,
		SRCCOPY
		);

	dcDlg.StretchBlt(
		m_iPrevPosX			,m_iPrevPosY,
		iPreViewWidth		,iPreViewHeight,
		&dcMatrix,
		0					,0,
		m_iMatrixNumX		,m_iMatrixNumY,
		SRCCOPY
		);

	dcPreview.DeleteDC();
	dcMatrix.DeleteDC();
}

void CSetting::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	DrawPreview();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

//o̓{^
void CSetting::OnExport() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData( TRUE );

	CClientDC	dcDlg( this );
	CDC			dcTemp;
	CDC			dcMatrix;
	CBitmap		bmpMatrix;

	bmpMatrix.CreateCompatibleBitmap(
		&dcDlg,
		m_iMatrixNumX,
		m_iMatrixNumY
		);
	
	m_pBitmap->GetBitmap( &m_tBitmap );

	dcTemp.CreateCompatibleDC( &dcDlg );
	dcMatrix.CreateCompatibleDC( &dcTemp );

	dcMatrix.SelectObject( &bmpMatrix );
	dcTemp.SelectObject( m_pBitmap );

	dcMatrix.StretchBlt(
		0,0,
		m_iMatrixNumX,m_iMatrixNumY,
		&dcTemp,
		0,0,
		m_tBitmap.bmWidth,m_tBitmap.bmHeight,
		SRCCOPY
		);

	CString strMatrix;
	strMatrix.Empty();

	int iPixelX = 0;
	int iPixelY = 0;

	while ( iPixelY < m_iMatrixNumY )
	{
		iPixelX = 0;

		while ( iPixelX < m_iMatrixNumX )
		{
			if ( dcMatrix.GetPixel( iPixelX , iPixelY ) == RGB( 0,0,0 ) )
			{
				strMatrix += "";
			}
			else
			{
				strMatrix += "";
			}
			iPixelX++;
		}
		strMatrix += 0x0D;
		strMatrix += 0x0A;
		iPixelY++;
	}	
	dcMatrix.DeleteDC();
	pDocIF->Insert( strMatrix );
	pDocIF->ReDraw();
}

void CSetting::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CDC* dcTemp;
	dcTemp = GetDC();
	dcTemp->FillSolidRect( &m_rectPreview , GetSysColor( COLOR_3DFACE ) );
	DrawPreview();

	m_strPreviewX.Format( "X : %d" , m_iMatrixNumX );
	UpdateData( FALSE );

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CSetting::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	CDC* dcTemp;
	dcTemp = GetDC();
	dcTemp->FillSolidRect( &m_rectPreview , GetSysColor( COLOR_3DFACE ) );
	DrawPreview();

	m_strPreviewY.Format( "Y : %d" , m_iMatrixNumY );
	UpdateData( FALSE );

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

int CSetting::GetPreviewSize( double iMatrixNum )
{
	int		iPreviewSize = 0;
	double	dPreviewSize = 0;

	dPreviewSize = ( iMatrixNum / MATRIXNUM ) * PREVIEWSIZE;

	iPreviewSize = ( int ) dPreviewSize;

	return iPreviewSize;
}
