/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.VariableNumber;

public class VariableDouble
implements VariableNumber,
Comparable {
    private static final long serialVersionUID = -6608858548559575301L;
    private double value;

    public VariableDouble() {
        this(0.0);
    }

    public VariableDouble(double value) {
        this.value = value;
    }

    public VariableDouble(String s) throws NumberFormatException {
        this.value = Double.valueOf(s);
    }

    public VariableDouble(Number value) {
        this.value = value.doubleValue();
    }

    public VariableDouble(VariableNumber value) {
        this.value = value.doubleValue();
    }

    public double add(double val) {
        this.value += val;
        return this.value;
    }

    public double subtract(double val) {
        this.value -= val;
        return this.value;
    }

    public double multiply(double val) {
        this.value *= val;
        return this.value;
    }

    public double divide(double val) {
        this.value /= val;
        return this.value;
    }

    public double increment() {
        this.value += 1.0;
        return this.value;
    }

    public double decrement() {
        this.value -= 1.0;
        return this.value;
    }

    public Number getValue() {
        return Boxing.box(this.value);
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.setValue(value.doubleValue());
    }

    public void setValue(VariableNumber value) {
        this.setValue(value.doubleValue());
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Object obj) {
        VariableDouble anotherDouble = (VariableDouble)obj;
        double thisVal = this.value;
        double anotherVal = anotherDouble.value;
        return Double.compare(thisVal, anotherVal);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableDouble) {
            return Double.doubleToLongBits(((VariableDouble)obj).doubleValue()) == Double.doubleToLongBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

