/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.text;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.core.lang.VariableInteger;
import shohaku.core.util.DateUtils;

class ToStringHelper {
    private static final int REPETITION_LIMIT = 1024;
    static final int NORMAL = 0;
    static final int CLASSES = 1;
    static final int DEEP_CLASSES = 2;

    ToStringHelper() {
    }

    static String toString(Object o, int style) {
        return ToStringHelper.toString(o, style, new VariableInteger());
    }

    private static String toString(Object o, int style, VariableInteger count) {
        if (o == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        ToStringHelper.appendObject(o, buf, style, count);
        return buf.toString();
    }

    private static String toString(Iterator i, int style, VariableInteger count) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean hasNext = i.hasNext();
        while (hasNext) {
            if (ToStringHelper.appendObject(i.next(), buf, style, count)) break;
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    private static String toString(Map m, int style, VariableInteger count) {
        if (m == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        if (m.size() == 0) {
            buf.append("{}");
        } else {
            buf.append('{');
            Iterator i = m.entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (key == m) {
                    buf.append("(this Map)");
                } else if (ToStringHelper.appendObject(key, buf, style, count)) break;
                buf.append(':');
                if (value == m) {
                    buf.append("(this Map)");
                } else if (ToStringHelper.appendObject(value, buf, style, count)) break;
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append('}');
        }
        return buf.toString();
    }

    private static String toString(Collection c, int style, VariableInteger count) {
        if (c == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        if (c.size() == 0) {
            buf.append("[]");
        } else {
            buf.append('[');
            Iterator i = c.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Object e = i.next();
                if (e == c) {
                    buf.append("(this Collection)");
                } else if (ToStringHelper.appendObject(e, buf, style, count)) break;
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
        return buf.toString();
    }

    private static void appendClass(Object o, StringBuffer buf) {
        buf.append('<');
        buf.append(o.getClass().getName());
        buf.append('>');
    }

    private static boolean appendObject(Object o, StringBuffer buf, int style, VariableInteger count) {
        if (count.intValue() >= 1024) {
            buf.append("...");
            return true;
        }
        if (2 == style) {
            ToStringHelper.appendClass(o, buf);
        } else if (1 == style && count.intValue() == 0) {
            ToStringHelper.appendClass(o, buf);
        }
        count.increment();
        if (o == null) {
            buf.append("null");
            return false;
        }
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                buf.append(ToStringHelper.toString(IteratorUtils.asIterator((Object[])o), style, count));
            } else {
                buf.append(ToStringHelper.toString(IteratorUtils.toStringArrayIterator(o), style, count));
            }
        } else if (o instanceof Map) {
            buf.append(ToStringHelper.toString((Map)o, style, count));
        } else if (o instanceof Collection) {
            buf.append(ToStringHelper.toString((Collection)o, style, count));
        } else if (o instanceof Timestamp) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Time) {
            buf.append(String.valueOf(o));
        } else if (o instanceof Date) {
            buf.append(DateUtils.format(o));
        } else if (o instanceof Calendar) {
            buf.append(DateUtils.format(o));
        } else {
            buf.append(String.valueOf(o));
        }
        return false;
    }
}

