/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

public class DecimalUtils {
    public static Number parse(String text, String pattern) {
        return DecimalUtils.parse(Locale.getDefault(), text, pattern);
    }

    public static Number parse(Locale locale, String text, String pattern) {
        return DecimalUtils.parse(new DecimalFormatSymbols(locale), text, pattern);
    }

    public static Number parse(DecimalFormatSymbols symbols, String text, String pattern) {
        try {
            DecimalFormat format = new DecimalFormat(pattern, symbols);
            return format.parse(text);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String format(long number, String pattern) {
        return DecimalUtils.format(Locale.getDefault(), number, pattern);
    }

    public static String format(Locale locale, long number, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        return format.format(number);
    }

    public static String format(DecimalFormatSymbols symbols, long number, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        return format.format(number);
    }

    public static String format(double number, String pattern) {
        return DecimalUtils.format(number, pattern);
    }

    public static String format(Locale locale, double number, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        return format.format(number);
    }

    public static String format(DecimalFormatSymbols symbols, double number, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        return format.format(number);
    }

    public static boolean isDecimal(CharSequence num, String pattern) {
        return DecimalUtils.isDecimal(Locale.getDefault(), num, pattern);
    }

    public static boolean isDecimal(Locale locale, CharSequence num, String pattern) {
        return DecimalUtils.isDecimal(new DecimalFormatSymbols(locale), num, pattern);
    }

    public static boolean isDecimal(DecimalFormatSymbols symbols, CharSequence num, String pattern) {
        if (num == null) {
            return false;
        }
        try {
            DecimalFormat format = new DecimalFormat(pattern, symbols);
            format.parse(num.toString());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isDecimal(CharSequence num, String[] patterns) {
        return DecimalUtils.isDecimal(Locale.getDefault(), num, patterns);
    }

    public static boolean isDecimal(Locale locale, CharSequence num, String[] patterns) {
        return DecimalUtils.isDecimal(new DecimalFormatSymbols(locale), num, patterns);
    }

    public static boolean isDecimal(DecimalFormatSymbols symbols, CharSequence num, String[] patterns) {
        if (num == null) {
            return false;
        }
        String snum = num.toString();
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(symbols);
        int i = 0;
        while (i < patterns.length) {
            try {
                format.applyPattern(patterns[i]);
                format.parse(snum);
                return true;
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        return false;
    }
}

