/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import java.util.Date;
import shohaku.core.util.DateUtils;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;

public class DateTimeExpression
implements CELExpression {
    private static final String[] dateFormats;
    private static final CELLiteral literal;

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("yyyy");
        list.add("yyyy-MM");
        list.add("yyyy-MM-dd");
        list.add("yyyy-MM-dd HH");
        list.add("yyyy-MM-dd HH:mm");
        list.add("yyyy-MM-dd HH:mm:ss");
        list.add("yyyy-MM-dd HH:mm:ss.S");
        list.add("yyyy-MM-dd HH:mm:ss.SS");
        list.add("yyyy-MM-dd HH:mm:ss.SSS");
        list.add("HH:mm");
        list.add("HH:mm:ss");
        list.add("HH:mm:ss.S");
        list.add("HH:mm:ss.SS");
        list.add("HH:mm:ss.SSS");
        dateFormats = list.toArray(new String[0]);
        literal = new CELLiteral('|', '|');
    }

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        int nextIndex = CELUtils.findNextIndex(expression, beginIndex, DateTimeExpression.literal.end);
        if (-1 == nextIndex) {
            throw new CELFormatException("format err :" + expression);
        }
        String exp = expression.substring(beginIndex + 1, nextIndex - 1);
        Date d = DateUtils.parse(exp, dateFormats);
        if (d == null) {
            throw new CELFormatException("format err :" + exp);
        }
        return new CELReturnValue(d, nextIndex);
    }
}

