/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.debug;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.io.IntrospectPrintStream;

public class DebugPrintStream
extends IntrospectPrintStream {
    protected static final List DEFAULT_PRINTERS;
    protected final List printers = new ArrayList(DEFAULT_PRINTERS);

    static {
        ArrayList<Printer> dps = new ArrayList<Printer>();
        dps.add(new Printer(){

            public void print(DebugPrintStream stream, Object o) {
                stream.printArray(o);
            }

            public boolean isAssignable(Object o) {
                return o != null && o.getClass().isArray();
            }
        });
        dps.add(new Printer(){

            public void print(DebugPrintStream stream, Object o) {
                stream.printMap((Map)o);
            }

            public boolean isAssignable(Object o) {
                return o instanceof Map;
            }
        });
        dps.add(new Printer(){

            public void print(DebugPrintStream stream, Object o) {
                stream.printColl((Collection)o);
            }

            public boolean isAssignable(Object o) {
                return o instanceof Collection;
            }
        });
        dps.add(new Printer(){

            public void print(DebugPrintStream stream, Object o) {
                stream.printDate((Date)o);
            }

            public boolean isAssignable(Object o) {
                return o instanceof Date;
            }
        });
        dps.add(new Printer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void print(DebugPrintStream stream, Object o) {
                DebugPrintStream debugPrintStream = stream;
                synchronized (debugPrintStream) {
                    stream.print(((Pattern)o).pattern());
                    stream.print(',');
                    stream.print(((Pattern)o).flags());
                }
            }

            public boolean isAssignable(Object o) {
                return o instanceof Pattern;
            }
        });
        DEFAULT_PRINTERS = Collections.unmodifiableList(dps);
    }

    public DebugPrintStream() {
        this(System.out);
    }

    public DebugPrintStream(boolean autoFlush) {
        this(System.out, autoFlush);
    }

    public DebugPrintStream(OutputStream out) {
        this(out, false);
    }

    public DebugPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Printer[] getPrinters() {
        List list = this.printers;
        synchronized (list) {
            return this.printers.toArray(new Printer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrinter(Printer printer) {
        List list = this.printers;
        synchronized (list) {
            this.printers.add(printer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrinter(int index, Printer printer) {
        List list = this.printers;
        synchronized (list) {
            this.printers.add(index, printer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePrinter(int index) {
        List list = this.printers;
        synchronized (list) {
            try {
                return this.printers.remove(index) != null;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePrinter(Printer printer) {
        List list = this.printers;
        synchronized (list) {
            return this.printers.remove(printer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object o) {
        try {
            List list = this.printers;
            synchronized (list) {
                Printer printer = null;
                Iterator i = this.printers.iterator();
                while (i.hasNext()) {
                    Printer p = (Printer)i.next();
                    if (!p.isAssignable(o)) continue;
                    printer = p;
                    break;
                }
                if (printer != null) {
                    DebugPrintStream debugPrintStream = this;
                    synchronized (debugPrintStream) {
                        printer.print(this, o);
                    }
                } else {
                    super.print(o);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object o, Printer printer) {
        if (printer.isAssignable(o)) {
            DebugPrintStream debugPrintStream = this;
            synchronized (debugPrintStream) {
                printer.print(this, o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, boolean value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, char value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, double value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, float value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, int value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, long value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object name, Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(name);
            this.print('=');
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object name, Object value1, Object value2) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title);
            this.print(" : ");
            this.print(name);
            this.print('=');
            this.print(value1);
            this.print(", ");
            this.print(value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o, Printer printer) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (printer.isAssignable(o)) {
                printer.print(this, o);
                this.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, boolean value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, char value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, double value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, float value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, int value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, long value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object name, Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, name, value);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object name, Object value1, Object value2) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.print(title, name, value1, value2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLine(int len) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            char[] c = new char[len];
            int i = 0;
            while (i < len) {
                c[i] = 45;
                ++i;
            }
            this.print(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(int len) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printLine(len);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(Object title, int len) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.println();
            this.printLine(len);
            this.printsp(2);
            this.print(title);
            this.printsp(2);
            this.printLine(len);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(int len, int beginLine, int endLine) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printlf(beginLine);
            this.printLine(len);
            this.printlf(endLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLine(int len) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            char[] c = new char[len];
            int i = 0;
            while (i < len) {
                c[i] = 61;
                ++i;
            }
            this.print(c);
        }
    }

    public void printDLineln(int len) {
        this.printDLineln(len, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLineln(Object title, int len) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.println();
            this.printDLine(len);
            this.printsp(2);
            this.print(title);
            this.printsp(2);
            this.printDLine(len);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLineln(int len, int beginLine, int endLine) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printlf(beginLine);
            this.printDLine(len);
            this.printlf(endLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeColl(Collection c) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (c == null) {
                this.printNull();
            } else if (c.size() == 0) {
                this.printClass(c);
                this.print("[]");
            } else {
                this.printClass(c);
                super.print('[');
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                while (hasNext) {
                    Object o = i.next();
                    this.printClass(o);
                    this.print((Object)(o == c ? "(this Collection)" : o));
                    hasNext = i.hasNext();
                    if (!hasNext) continue;
                    super.print(", ");
                }
                super.print(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeMap(Map m) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (m == null) {
                this.printNull();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.print("{}");
            } else {
                this.printClass(m);
                this.print('{');
                boolean st = true;
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (st) {
                        st = false;
                    } else {
                        this.print(", ");
                    }
                    this.printClass(key);
                    this.print((Object)(key == m ? "(this Map)" : key));
                    this.print(':');
                    this.printClass(value);
                    this.print((Object)(value == m ? "(this Map)" : value));
                }
                this.print('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArrayTbl(Object a) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (a == null) {
                this.printNull();
                super.println();
            } else if (a.getClass().isArray()) {
                this.printClass(a.getClass());
                super.println('[');
                int size = Array.getLength(a);
                int i = 0;
                while (i < size) {
                    this.printsp(2);
                    this.printArray(Array.get(a, i));
                    super.println();
                    ++i;
                }
                super.println(']');
            } else {
                super.println(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArrayTbl(Object a, int column) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (a == null) {
                this.printNull();
                super.println();
            } else if (a.getClass().isArray()) {
                int size = Array.getLength(a);
                if (size == 0 || column <= 0) {
                    this.printClass(a);
                    this.println("[]");
                } else {
                    this.printClass(a);
                    super.println('[');
                    int row = size % column == 0 ? size / column : size / column + 1;
                    int inx = 0;
                    int i = 0;
                    while (i < row && inx < size) {
                        this.printsp(2);
                        int j = 0;
                        while (j < column && inx < size) {
                            this.printArray(Array.get(a, i));
                            if (j + 1 < column && inx + 1 < size) {
                                this.print(", ");
                            }
                            ++inx;
                            ++j;
                        }
                        this.println();
                        ++i;
                    }
                    super.println(']');
                }
            } else {
                super.println(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCollTbl(Collection c) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (c == null) {
                this.printNull();
                super.println();
            } else {
                if (c.size() == 0) {
                    this.printClass(c);
                    this.println("[]");
                    return;
                }
                this.printClass(c);
                this.println('[');
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    this.printsp(2);
                    Object o = i.next();
                    this.println((Object)(o == c ? "(this Collection)" : o));
                }
                this.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCollTbl(Collection c, int column) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (c == null) {
                this.printNull();
                super.println();
            } else {
                if (c.size() == 0 || column <= 0) {
                    this.printClass(c);
                    this.println("[]");
                    return;
                }
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                this.printClass(c);
                this.println('[');
                while (hasNext) {
                    this.printsp(2);
                    int icolumn = 0;
                    while (hasNext && icolumn < column) {
                        Object o = i.next();
                        this.print((Object)(o == c ? "(this Collection)" : o));
                        hasNext = i.hasNext();
                        if (hasNext) {
                            super.print(", ");
                        }
                        ++icolumn;
                    }
                    this.println();
                }
                this.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMapTbl(Map m) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            if (m == null) {
                this.printNull();
                super.println();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.println("{}");
            } else {
                this.printClass(m);
                this.println('{');
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    this.printsp(2);
                    this.print((Object)(key == m ? "(this Map)" : key));
                    this.print(':');
                    this.println((Object)(value == m ? "(this Map)" : value));
                }
                this.println('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeanTbl(Object bean) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            Map props;
            try {
                props = BeanUtilities.getProperties(bean);
            }
            catch (Exception e) {
                this.println();
                return;
            }
            this.print(bean.getClass().getName());
            this.println('{');
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ("class".equals(e.getKey())) continue;
                this.printsp(2);
                this.print((String)e.getKey());
                this.print('=');
                this.print(e.getValue());
                this.println();
            }
            this.println('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeansTbl(Object[] beans) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printClass(beans);
            this.println();
            this.println('[');
            int i = 0;
            while (i < beans.length) {
                this.printsp(2);
                this.print(91 + i + 93);
                this.printBeanTbl(beans[i]);
                ++i;
            }
            this.println(']');
        }
    }

    public void printDate(Date date) {
        this.print(DebugPrintStream.formatDate(date));
    }

    public void printCurrentTime() {
        this.printDate(new Date(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompBean(Object from, Object to) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            Map toProp;
            Map fromProp;
            try {
                fromProp = BeanUtilities.getProperties(from);
                toProp = BeanUtilities.getProperties(to);
            }
            catch (Exception e) {
                this.println();
                return;
            }
            this.printCompMap(fromProp, toProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompMap(Map from, Map to) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            Iterator i = from.entrySet().iterator();
            while (i.hasNext()) {
                Object toValue;
                Map.Entry e = i.next();
                Object fromValue = e.getValue();
                if (DebugPrintStream.deepEquals(fromValue, toValue = to.get(e.getKey()))) {
                    this.println("TRUE", e.getKey(), fromValue, toValue);
                    continue;
                }
                this.println("FALSE", e.getKey(), fromValue, toValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printType(Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printClass(value);
            this.print(':');
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeln(Object value) {
        DebugPrintStream debugPrintStream = this;
        synchronized (debugPrintStream) {
            this.printClass(value);
            this.print(':');
            this.println(value);
        }
    }

    protected static Object formatDate(Object date) {
        if (date instanceof Timestamp) {
            String s = DebugPrintStream.formatDate((Date)date, "yyyy-MM-dd HH:mm:ss");
            return String.valueOf(s) + '.' + ((Timestamp)date).getNanos();
        }
        if (date instanceof Time) {
            return DebugPrintStream.formatDate((Date)date, "HH:mm:ss");
        }
        if (date instanceof Date) {
            return DebugPrintStream.formatDate((Date)date, "yyyy-MM-dd HH:mm:ss.SSS");
        }
        return date;
    }

    protected static String formatDate(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    protected static boolean deepEquals(Object from, Object to) {
        if (from == null || to == null) {
            return from == to;
        }
        if (from.getClass().isArray() && to.getClass().isArray()) {
            if (!from.getClass().getComponentType().equals(from.getClass().getComponentType())) {
                return false;
            }
            int size = Array.getLength(from);
            if (size != Array.getLength(to)) {
                return false;
            }
            int i = 0;
            while (i < size) {
                Object o1 = Array.get(from, i);
                Object o2 = Array.get(to, i);
                if (o1 == null || o2 == null ? o1 != o2 : !DebugPrintStream.deepEquals(o1, o2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return from.equals(to);
    }

    public static interface Printer {
        public void print(DebugPrintStream var1, Object var2);

        public boolean isAssignable(Object var1);
    }
}

