/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import shohaku.core.helpers.Eval;
import shohaku.ginkgo.DefaultDocumentCompositeRule;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.ginkgo.SAXDocumentParser;

public class Ginkgo {
    private static final Log staticLog;
    private Log log;
    private SAXDocumentParser saxDocumentParser;
    private ClassLoader classLoader;
    private Document document;
    private DocumentCompositeRule documentCompositeRule;
    private NodeCompositeRule nodeCompositeRule;
    private boolean errThrowable;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.ginkgo.Ginkgo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        staticLog = LogFactory.getLog((Class)clazz);
    }

    public Ginkgo() {
        this(Ginkgo.newDefaultDocumentCompositeRule());
    }

    public Ginkgo(DocumentCompositeRule docRule) {
        if (docRule == null) {
            throw new NullPointerException("DocumentCompositeRule is null");
        }
        this.initialize(docRule);
    }

    private void initialize(DocumentCompositeRule docRule) {
        this.documentCompositeRule = docRule;
        this.log = staticLog;
        this.saxDocumentParser = new SAXDocumentParser(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.ginkgo.Ginkgo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classLoader = clazz.getClassLoader();
        this.nodeCompositeRule = null;
        this.errThrowable = false;
    }

    public void parse(NodeCompositeRule rule, InputStream inStream) {
        this.parse(rule, inStream, null);
    }

    public void parse(NodeCompositeRule rule, InputStream inStream, Document parent) {
        if (parent != null && !parent.isPreserve()) {
            parent = parent.getPreserveDocument();
        }
        this.parse(rule, new InputSource(inStream), parent);
    }

    public void parse(NodeCompositeRule rule, InputSource input) {
        this.parse(rule, input, null);
    }

    public void parse(NodeCompositeRule rule, InputSource input, Document parent) {
        if (Eval.isOrNull((Object)rule, (Object)input)) {
            throw new NullPointerException("argument is null");
        }
        this.prepare(rule, parent);
        try {
            this.getSAXDocumentParser().parse(input);
        }
        catch (SAXException e) {
            throw new GinkgoException("ginkgo parse err", e);
        }
        catch (IOException e) {
            throw new GinkgoException("ginkgo parse err", e);
        }
    }

    private void prepare(NodeCompositeRule rule, Document parent) {
        this.nodeCompositeRule = rule;
        this.document = new Document(this, rule, parent);
        this.nodeCompositeRule.parse(this, this.document);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        if (log == null) {
            throw new NullPointerException();
        }
        this.log = log;
    }

    public SAXDocumentParser getSAXDocumentParser() {
        return this.saxDocumentParser;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isErrThrowable() {
        return this.errThrowable;
    }

    public void setErrThrowable(boolean errThrowable) {
        this.errThrowable = errThrowable;
    }

    public Document getDocument() {
        return this.document;
    }

    public NodeCompositeRule getNodeCompositeRule() {
        return this.nodeCompositeRule;
    }

    public DocumentCompositeRule getDocumentCompositeRule() {
        return this.documentCompositeRule;
    }

    private static DefaultDocumentCompositeRule newDefaultDocumentCompositeRule() {
        return new DefaultDocumentCompositeRule();
    }
}

