/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.ArrayList;
import java.util.Iterator;
import shohaku.core.beans.FactoryMethodInfo;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.beans.MethodInfo;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

public class ObjectNode
extends AbstractValueNode {
    protected Object generateValue() {
        Class objectClass;
        String className = this.getAttribute("class", "java.lang.Object");
        try {
            objectClass = ResourceLoader.getClass((String)className, (ClassLoader)this.getContext().getClassLoader());
        }
        catch (NoSuchResourceException e) {
            throw new GinkgoException("illegal class name is specified. " + className, e);
        }
        Object obj = null;
        FactoryMethodInfo factory = null;
        ArrayList<Object> methods = new ArrayList<Object>();
        Iterator i = this.getContext().valueElementIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            Object o = n.getNodeValue();
            if (o == null || !(o instanceof MethodInfo) && !(o instanceof FactoryMethodInfo)) {
                throw new GinkgoException("element is illegal. MethodInfo or ConstructorInfo is right. element:" + o);
            }
            if (o instanceof FactoryMethodInfo) {
                if (factory != null) {
                    throw new GinkgoException("FactoryMethodInfo except for one is illegal. element:" + o);
                }
                factory = (FactoryMethodInfo)o;
                continue;
            }
            methods.add(o);
        }
        try {
            obj = factory != null ? (factory.getObjectType() == null ? factory.invoke(objectClass) : factory.invoke()) : ResourceLoader.getInstance((Class)objectClass);
            i = methods.iterator();
            while (i.hasNext()) {
                MethodInfo mi = (MethodInfo)i.next();
                mi.invoke(obj);
            }
        }
        catch (ObjectCreationException e) {
            throw new GinkgoException("object creative error. :" + objectClass, e);
        }
        catch (InvocationBeansException e) {
            throw new GinkgoException("object creative error. :" + objectClass, e);
        }
        return obj;
    }
}

