/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo;

/**
 * テキストのノードを提供します。このクラスはシステム内部でのみ生成されます。
 */
class TextNode implements Node {

    /* テキスト. */
    private String text;

    /**
     * デフォルトコンストラクタ。
     */
    public TextNode() {
        super();
    }

    /**
     * テキストを格納して初期化します。
     * 
     * @param text
     *            テキスト
     */
    public TextNode(String text) {
        super();
        this.text = text;
    }

    /**
     * テキストを返却します。
     * 
     * @return テキスト
     */
    public Object getNodeValue() {
        return text;
    }

    /**
     * <code>Node.TYPE_TEXT</code>か<code>Node.TYPE_VALUE</code>の場合<code>true</code>を返却します。
     * 
     * @param type
     *            検証する種別
     * @return <code>Node.TYPE_TEXT</code>か<code>Node.TYPE_VALUE</code>の場合<code>true</code>
     */
    public boolean isType(int type) {
        return (type == TYPE_TEXT || type == TYPE_VALUE);
    }

    /**
     * <code>Node.SCOPE_DOCUMENT</code>を返却します。
     * 
     * @return code>Node.SCOPE_DOCUMENT</code>
     */
    public int getScope() {
        return SCOPE_DOCUMENT;
    }

    /**
     * ノードの識別子を返却します。
     * 
     * @return ノードの識別子
     */
    public String getId() {
        return null;
    }

    /**
     * <code>null</code>を返却します。
     * 
     * @return <code>null</code>
     */
    public NodeContext getContext() {
        return null;
    }

    /**
     * 常に<code>null</code>を返却します。
     * 
     * @param name
     *            属性名
     * @return 常に<code>null</code>
     */
    public String getAttribute(String name) {
        return null;
    }

    /**
     * 常に第二引数を返却します。
     * 
     * @param name
     *            属性名
     * @param defaultValue
     *            属性が存在しない場合に返却される値
     * @return 第二引数
     */
    public String getAttribute(String name, String defaultValue) {
        return defaultValue;
    }

    /**
     * このノードのテキストをそのまま返却します。
     * 
     * @return テキスト情報
     */
    public String getText() {
        return text;
    }

    /*
     * Event
     */

    /**
     * 空実装。
     * 
     * @param nodeContext
     *            ノードのコンテキスト情報
     */
    public void initialize(NodeContext nodeContext) {
        // no op
    }

    /**
     * 空実装。
     */
    public void begin() {
        // no op
    }

    /**
     * 空実装。
     * 
     * @param node
     *            子のノード
     */
    public void child(Node node) {
        // no op
    }

    /**
     * 空実装。
     */
    public void end() {
        // no op
    }

    /**
     * 空実装。
     */
    public void finish() {
        // no op
    }

}
