/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.base;

import shohaku.core.util.codec.UnicodeEscapesCoder;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * Character 型のデータを表す値型のノードを提供します。
 */
public class CharacterNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        String body = getText();
        if (body.length() == 0) {
            throw new GinkgoException("text isn't specified.");
        }
        if (body.length() > 1 && '\'' == body.charAt(0) && '\'' == body.charAt(body.length() - 1)) {
            body = body.substring(1, (body.length() - 1));
        }
        if (body.length() > 1) {
            try {
                body = UnicodeEscapesCoder.decode(body);
            } catch (IllegalArgumentException e) {
                throw new GinkgoException("illegal format of Character. " + body);
            }
        }
        return new Character(body.charAt(0));
    }

}
