/**
* Counts order summary after selecting courier
* @return void
* @param object
*/
function ordersCouriers( obj ){

  if( obj.value != '' )
    aCourier = obj.value.split( "|" );
  else
    aCourier = Array( 0, '0' );

  fDeliveryCost = Math.abs( aCourier[1] );

  gEBI( "deliveryCost" ).innerHTML  = changePriceFormat( fDeliveryCost );
  gEBI( "summaryCost" ).innerHTML   = changePriceFormat( +fOrderCost + fDeliveryCost );
} // end function ordersCouriers

var aUserDataNames = new Array( 'sFirstName', 'sLastName', 'sCompanyName', 'sStreet', 'sZipCode', 'sCity', 'sTelephone', 'sEmail' );

function saveUserData( sName, sValue ){
  createCookie( sName, sValue, 2 );
}

function createCookie( sName, sValue, iDays ){
  sValue = escape( sValue );
  if( iDays ){
    var oDate = new Date();
    oDate.setTime( oDate.getTime() + ( iDays*24*60*60*1000 ) );
    var sExpires = "; expires="+oDate.toGMTString();
  }
  else
    var sExpires = "";
  document.cookie = sName+"="+sValue+sExpires+"; path=/";
}

function throwCookie( sName ){
  var sNameEQ = sName + "=";
  var aCookies = document.cookie.split( ';' );
  for( var i=0; i < aCookies.length; i++ ){
    var c = aCookies[i];
    while( c.charAt(0) == ' ' )
      c = c.substring( 1, c.length );
    if( c.indexOf( sNameEQ ) == 0 )
      return c.substring( sNameEQ.length, c.length );
  }
  return null;
}

function delCookie( sName ){
  createCookie( sName, "", -1 );
}

function checkSavedUserData( ){
  var iCount = aUserDataNames.length;
  var sCookie = null;
  var oForm = gEBI( "order" );
  for( var i = 0; i < iCount; i++ ){
    sCookie = throwCookie( aUserDataNames[i] );
    if( sCookie && sCookie != '' ){
      if( gEBI( aUserDataNames[i] ) )
        gEBI( aUserDataNames[i] ).value = unescape( sCookie );
      else if( oForm[aUserDataNames[i]] )
        oForm[aUserDataNames[i]].value = unescape( sCookie );
    }
  } // end for
} // end function checkSavedUserData

function delSavedUserData( ){
  var iCount = aUserDataNames.length;
  var sCookie = null;
  for( var i = 0; i < iCount; i++ ){
    delCookie( aUserDataNames[i] );
  } // end for
} // end function delSavedUserData