<?php
if( !function_exists( 'dbThrowOrderIdTemp' ) ){
  /**
  * Return temporary order id
  * @return int
  */
  function dbThrowOrderIdTemp( ){
    global $oFF;
    $iOrder = throwLastId( DB_ORDERS, 0 ) + 1;
    $oFF->setLock( );
    $oFF->setRow( Array( $iOrder, LANGUAGE, 0, time( ) ) );
    $oFF->addToFile( DB_ORDERS, 'rsort' ); 
    return $iOrder;
  } // end function dbThrowOrderIdTemp
}

if( !function_exists( 'dbThrowOrder' ) ){
  /**
  * Return order basic data
  * @return array
  * @param int  $iOrder
  */
  function dbThrowOrder( $iOrder ){
    return $GLOBALS['oFF']->throwData( DB_ORDERS, $iOrder, 0 );
  } // end function dbThrowOrder
}

if( !function_exists( 'dbThrowOrderMd5' ) ){
  /**
  * Return order basic data - check using md5
  * @return array
  * @param string $sOrder
  */
  function dbThrowOrderMd5( $sOrder ){
    $aFile = file( DB_ORDERS );
    $iCount= count( $aFile );
    for( $i = 1; $i < $iCount; $i++ ){
      $aExp = explode( '$', $aFile[$i] );
      if( $sOrder == md5( $aExp[0] ) && $aExp[2] == 0 )
        return $aExp;
    } // end for

    return null;
  } // end function dbThrowOrderMd5
}

if( !function_exists( 'dbThrowOrderExt' ) ){
  /**
  * Return order extensions
  * @return array
  * @param int  $iOrder
  */
  function dbThrowOrderExt( $iOrder ){
    return $GLOBALS['oFF']->throwData( DB_ORDERS_EXT, $iOrder, 0 );
  } // end function dbThrowOrderExt
}

if( !function_exists( 'dbCheckOrderProducts' ) ){
  /**
  * Check exist any product in basket
  * @return bool
  * @param int  $iOrder
  */
  function dbCheckOrderProducts( $iOrder ){
    $aFile  = file( DB_ORDERS_PRODUCTS );
    $iCount = count( $aFile );
    for( $i = 1; $i < $iCount; $i++ ){
      $aExp =  explode( '$', $aFile[$i] );
      if( $aExp[1] == $iOrder ){
        return true;
      }
    }
    return null;
  } // end function dbCheckOrderProducts
}

if( !function_exists( 'dbCheckOrderProduct' ) ){
  /**
  * Check exist product in basket
  * @return bool
  * @param int  $iOrder
  $ @param int  $iProduct
  */
  function dbCheckOrderProduct( $iOrder, $iProduct ){
    $aFile =  file( DB_ORDERS_PRODUCTS );
    $iCount = count( $aFile );
    for( $i = 1; $i < $iCount; $i++ ){
      $aFile[$i]  = rtrim( $aFile[$i] );
      $aExp       = explode( '$', $aFile[$i] );
      if( isset( $aExp[1] ) && $aExp[1] == $iOrder && $aExp[2] == $iProduct ){
        return $aExp;
      }
    }
    return null;
  } // end function dbCheckOrderProduct
}

if( !function_exists( 'dbAddOrderProduct' ) ){
  /**
  * Add product to basket
  * @return void
  * @param array  $aProduct
  * @param int    $iQuantity
  * @param int    $iOrder
  */
  function dbAddOrderProduct( $aProduct, $iQuantity, $iOrder ){
    global $oFF;
    $iElement = throwLastId( DB_ORDERS_PRODUCTS, 0 ) + 1;
    $oFF->setRow( Array( $iElement, $iOrder, $aProduct['iProduct'], $iQuantity, $aProduct['fPrice'], $aProduct['sName'] ) );
    $oFF->addToFile( DB_ORDERS_PRODUCTS, 'end' );
  } // end function dbAddOrderProduct
}

if( !function_exists( 'dbSaveOrderProduct' ) ){
  /**
  * Save product to file
  * @return void
  * @param array  $aData
  */
  function dbSaveOrderProduct( $aData ){
    global $oFF;
    $oFF->setLock( );
    $oFF->setRow( Array( $aData[0], $aData[1], $aData[2], $aData[3], $aData[4], $aData[5] ) );
    $oFF->changeInFile( DB_ORDERS_PRODUCTS, $aData[0], 0 );
  } // end function dbSaveOrderProduct
}

if( !function_exists( 'dbSaveOrderProducts' ) ){
  /**
  * Save products quantity to file
  * @return void
  * @param array  $aElements
  */
  function dbSaveOrderProducts( $aElements ){
    $aFile  = file( DB_ORDERS_PRODUCTS );
    $rFile  = fopen( DB_ORDERS_PRODUCTS, 'w' );
    flock( $rFile, LOCK_EX );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i]  = rtrim( $aFile[$i] );
        $aExp       = explode( '$', $aFile[$i] );
        if( isset( $aElements[$aExp[0]] ) && $aElements[$aExp[0]] >= 1 )
          $aFile[$i] = $aExp[0].'$'.$aExp[1].'$'.$aExp[2].'$'.sprintf( '%01.0f', $aElements[$aExp[0]] ).'$'.$aExp[4].'$'.$aExp[5].'$'."\n";
        else
          $aFile[$i] .= "\n";
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for

    flock( $rFile, LOCK_UN );
    fclose( $rFile );
  } // end function dbSaveOrderProducts
}

if( !function_exists( 'dbDelOrderElement' ) ){
  /**
  * Delete products in basket
  * @return void
  * @param int  $iOrder
  * @param int  $iElement
  */
  function dbDelOrderElement( $iOrder, $iElement ){
    $aFile =  file( DB_ORDERS_PRODUCTS );
    $rFile =  fopen( DB_ORDERS_PRODUCTS, 'w' );
    flock( $rFile, LOCK_EX );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i] = ereg_replace( "\r", "", $aFile[$i] );
        $aExp =      explode( '$', $aFile[$i] );
        if( isset( $iElement ) ){
          if( $aExp[0] == $iElement && $aExp[1] == $iOrder ){
            $aFile[$i] = '';
          }
        }
        else{
          if( $aExp[1] == $iOrder )
            $aFile[$i] = '';
        }
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for
    flock( $rFile, LOCK_UN );
    fclose( $rFile );
  } // end function dbDelOrderElement
}

if( !function_exists( 'dbDelOrderMass' ) ){
  /**
  * Delete older then 24h not finished orders
  * @return void
  */
  function dbDelOrderMass( ){

    $aFile  = file( DB_ORDERS );
    $iCount = count( $aFile );
    $rFile  = fopen( DB_ORDERS, 'w' );
    flock( $rFile, LOCK_EX );
    $iTime  = time( );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aExp = explode( '$', $aFile[$i] );
        $aExp[3] = trim( $aExp[3] );
        if( is_numeric( $aExp[3] ) && $aExp[2] == 0 ){
          $iDiff = $iTime - $aExp[3];
          if( $iDiff > 86400 ){
            $aFile[$i]      = null;
            $aId[$aExp[0]]  = true;
          }
        }
      }
      fwrite( $rFile, $aFile[$i] );
    } // end for
    
    flock( $rFile, LOCK_UN );
    fclose( $rFile );
    
    if( isset( $aId ) && is_array( $aId ) ){
      $aFile  = file( DB_ORDERS_PRODUCTS );
      $iCount = count( $aFile );
      $rFile  = fopen( DB_ORDERS_PRODUCTS, 'w' );
      flock( $rFile, LOCK_EX );

      for( $i = 0; $i < $iCount; $i++ ){
        if( $i > 0 ){
          $aExp = explode( '$', $aFile[$i] );
          if( isset( $aId[$aExp[1]] ) ){
            $aFile[$i]  = null;
          }
        }
        fwrite( $rFile, $aFile[$i] );
      } // end for
      flock( $rFile, LOCK_UN );
      fclose( $rFile );
    }
  } // end function dbDelOrderMass
}

if( !function_exists( 'dbDelOrder' ) ){
  /**
  * Delete order
  * @return void
  * @param int  $iOrder
  */
  function dbDelOrder( $iOrder ){
    global $oFF;
    $oFF->setLock( );
    $oFF->deleteInFile( DB_ORDERS, $iOrder, 0 );
    $oFF->setLock( );
    $oFF->deleteInFile( DB_ORDERS_EXT, $iOrder, 0 );
  } // end function dbDelOrder
}

if( !function_exists( 'dbListBasket' ) ){
  /**
  * Return basket
  * @return array
  * @param int  $iOrder
  */
  function dbListBasket( $iOrder ){
    return $GLOBALS['oFF']->throwFileArrayClause( DB_ORDERS_PRODUCTS, null, 1, $iOrder );
  } // end function dbListBasket
}

if( !function_exists( 'dbThrowOrdersStatus' ) ){
  /**
  * Return array
  * index - id order
  * value - order status
  * @return array
  */
  function dbThrowOrdersStatus( ){
    return $GLOBALS['oFF']->throwFileArraySmall( DB_ORDERS, null, 0, 2 );
  } // end function dbThrowOrdersStatus
}

if( !function_exists( 'dbListOrders' ) ){
  /**
  * Return order to array
  * @return array
  * @param array  $aParams
  * @param int    $iList
  */
  function dbListOrders( $aParams, $iList ){
    global $oFF;
    $aStatus = dbThrowOrdersStatus( );
    return $oFF->throwFileArrayFunctionPages( DB_ORDERS_EXT, null, $GLOBALS['iPage'], $iList, 'dbListOrdersCheck', Array( $aParams, $aStatus ) );
  } // end function dbListOrders
}

if( !function_exists( 'dbListOrdersCheck' ) ){
  /**
  * Checking data of order in order list
  * @return bool
  * @param array  $aData
  * @param array  $aCheck
  */
  function dbListOrdersCheck( $aData, $aCheck ){
    if( is_array( $aData ) ){
      $bReturn = true;

      if( isset( $aCheck[0][0] ) ){ // status
        if( isset( $aCheck[1][$aData[0]] ) && $aCheck[1][$aData[0]] == $aCheck[0][0] ){}
        else
          $bReturn = null;
      }

      if( isset( $bReturn ) && isset( $aCheck[0][1] ) ){ // word
        if( !stristr( implode( ' ', $aData ), $aCheck[0][1] ) )
          $bReturn = null;
      }
      
      return $bReturn;
    }
    else
      return null;
  } // end function dbListOrdersCheck
}

if( !function_exists( 'dbSaveOrder' ) ){
  /**
  * Save order
  * @return void
  * @param array  $aForm
  */
  function dbSaveOrder( $aForm ){
    global $oFF;
    $oFF->setLock( );
    $oFF->setRow( Array( $aForm['iOrder'], LANGUAGE, 1, null ) );
    $oFF->changeInFile( DB_ORDERS , $aForm['iOrder'], 0 );
  } // end function dbSaveOrder
}

if( !function_exists( 'dbAddOrderExtension' ) ){
  /**
  * Add order extensions to file
  * @return void
  * @param array  $aData
  * @param bool   $bErase
  */
  function dbAddOrderExtensions( $aData, $bErase = true ){
    global $oFF;
    if( isset( $bErase ) ){
      $oFF->setLock( );
      $oFF->deleteInFile( DB_ORDERS_EXT, $aData[0], 0 );
    }

    $oFF->setLock( );
    $oFF->setRow( $aData );
    $oFF->addToFile( DB_ORDERS_EXT, 'rsort' );  
  } // end function dbAddOrderExtension
}

if( !function_exists( 'dbSaveOrderStatus' ) ){
  /**
  * Save order status to file
  * @return void
  * @param int    $iOrder
  * @param int    $iStatus
  */
  function dbSaveOrderStatus( $iOrder, $iStatus ){
    $aFile  = file( DB_ORDERS );
    $rFile  = fopen( DB_ORDERS, 'w' );
    flock( $rFile, LOCK_EX );
    $iCount = count( $aFile );

    for( $i = 0; $i < $iCount; $i++ ){
      if( $i > 0 ){
        $aFile[$i]  = ereg_replace( "\r", '', $aFile[$i] );
        $aExp       = explode( '$', $aFile[$i] );
        if( $aExp[0] == $iOrder ){
          $aFile[$i] = $aExp[0].'$'.$aExp[1].'$'.$iStatus.'$$'."\n";
          $bFound = true;
        }
      }

      fwrite( $rFile, $aFile[$i] );
    } // end for

    if( !isset( $bFound ) ){
      fwrite( $rFile, $iOrder.'$'.LANGUAGE.'$'.$iStatus.'$$'."\n" );
    }

    flock( $rFile, LOCK_UN );
    fclose( $rFile );
  } // end function dbSaveOrderStatus
}
?>