/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import jp.sf.skype.Application;
import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Stream;
import jp.sf.skype.StreamAdapter;
import jp.sf.skype.TestData;
import junit.framework.TestCase;

public class Ap2ApAPITest
extends TestCase {
    public void testApplication() throws Exception {
        Skype.setDebug(true);
        Application application = Skype.addApplication("AP2AP");
        Friend friend = TestData.getFriend();
        this.checkConnectableFriendsBeforeConnecting(application);
        try {
            Stream stream = application.connect(friend);
            this.checkConnectableFriendsAfterConnecting(application);
            this.checkConnectedFriends(application, friend);
            this.checkTextCommnunication(stream);
            this.checkDatagramCommnunication(stream);
        }
        finally {
            application.finish();
        }
    }

    private void checkConnectableFriendsBeforeConnecting(Application application) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectableFriends();
        Ap2ApAPITest.assertTrue((1 <= connectableFriends.length ? 1 : 0) != 0);
    }

    private void checkConnectableFriendsAfterConnecting(Application application) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectableFriends();
        Ap2ApAPITest.assertTrue((connectableFriends.length >= 0 ? 1 : 0) != 0);
    }

    private void checkConnectedFriends(Application application, Friend friend) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectedFriends();
        Ap2ApAPITest.assertEquals((int)1, (int)connectableFriends.length);
        Ap2ApAPITest.assertEquals((Object)friend, (Object)connectableFriends[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTextCommnunication(Stream stream) throws Exception {
        final Object lock = new Object();
        final String[] result = new String[1];
        stream.addCommunicationListener(new StreamAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textReceived(String text) {
                result[0] = text;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        stream.write("Hello, World!");
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Ap2ApAPITest.assertEquals((String)"Hello, World!", (String)result[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatagramCommnunication(Stream stream) throws Exception {
        final Object lock = new Object();
        final String[] result = new String[1];
        stream.addCommunicationListener(new StreamAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void datagramReceived(String datagram) {
                result[0] = datagram;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        stream.send("Hello, World!");
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Ap2ApAPITest.assertEquals((String)"Hello, World!", (String)result[0]);
    }
}

