/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.skype.ApplicationListener;
import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Stream;
import jp.sf.skype.Utils;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;
import jp.sf.skype.connector.ConnectorListener;
import jp.sf.skype.connector.MessageProcessor;

public final class Application {
    private final String name;
    private List<ApplicationListener> listeners = new ArrayList<ApplicationListener>();
    private Map<String, Stream> streams = new HashMap<String, Stream>();
    private ConnectorListener dataListener = new DataListener();

    Application(String name) {
        assert (name != null);
        this.name = name;
    }

    void initalize() throws SkypeException {
        try {
            String createResponse = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
            try {
                Utils.checkError(createResponse);
            }
            catch (SkypeException e) {
                String deleteResponse = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                Utils.checkError(deleteResponse);
                String retryResponse = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
                Utils.checkError(retryResponse);
            }
            Connector.getInstance().addConnectorListener(this.dataListener);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void finish() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
        Connector.getInstance().removeConnectorListener(this.dataListener);
    }

    private void handleData(String dataResponse) {
        try {
            if (this.isReceivedText(dataResponse)) {
                String data = dataResponse.substring("RECEIVED ".length());
                String streamId = data.substring(0, data.indexOf(61));
                String dataHeader = "ALTER APPLICATION " + this.getName() + " READ " + streamId;
                String response = Connector.getInstance().execute(dataHeader);
                Utils.checkError(response);
                String text = response.substring(dataHeader.length() + 1);
                this.streams.get(streamId).fireTextReceived(text);
            } else if (this.isReceivedDatagram(dataResponse)) {
                String data = dataResponse.substring("DATAGRAM ".length());
                String streamId = data.substring(0, data.indexOf(32));
                String datagram = data.substring(data.indexOf(32) + 1);
                this.streams.get(streamId).fireDatagramReceived(datagram);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("can't handle data", e);
        }
    }

    private boolean isReceivedText(String dataResponse) {
        return dataResponse.startsWith("RECEIVED ") && "RECEIVED ".length() < dataResponse.length();
    }

    private boolean isReceivedDatagram(String dataResponse) {
        return dataResponse.startsWith("DATAGRAM ");
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] listeners;
        assert (stream != null);
        ApplicationListener[] applicationListenerArray = listeners = this.listeners.toArray(new ApplicationListener[0]);
        int n = 0;
        int n2 = applicationListenerArray.length;
        while (n < n2) {
            ApplicationListener listener = applicationListenerArray[n];
            listener.connected(stream);
            ++n;
        }
    }

    void fireDisconnected(Stream stream) {
        ApplicationListener[] listeners;
        assert (stream != null);
        ApplicationListener[] applicationListenerArray = listeners = this.listeners.toArray(new ApplicationListener[0]);
        int n = 0;
        int n2 = applicationListenerArray.length;
        while (n < n2) {
            ApplicationListener listener = applicationListenerArray[n];
            listener.disconnected(stream);
            ++n;
        }
    }

    public String getName() {
        return this.name;
    }

    public Stream connect(final Friend friend) throws SkypeException {
        Utils.checkNotNull("friend", friend);
        try {
            final String[] id = new String[1];
            final String[] error = new String[1];
            MessageProcessor processor = new MessageProcessor(){

                public void messageReceived(String message) {
                    if (!message.equals("APPLICATION " + Application.this.getName() + " CONNECTING " + friend.getId()) && !message.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                        if (message.startsWith("APPLICATION " + Application.this.getName() + " STREAMS ")) {
                            id[0] = message.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                            this.releaseLock();
                        } else if (message.startsWith("ERROR ")) {
                            error[0] = message.substring("ERROR ".length());
                            this.releaseLock();
                        }
                    }
                }
            };
            Connector.getInstance().execute("ALTER APPLICATION " + this.getName() + " CONNECT " + friend.getId(), processor);
            Utils.checkError(error[0]);
            return this.streams.get(id[0]);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.remove(listener);
    }

    public Friend[] getAllConnectableFriends() throws SkypeException {
        return this.getAllFriends("CONNECTABLE");
    }

    public Friend[] getAllConnectedFriends() throws SkypeException {
        return this.getAllFriends("STREAMS");
    }

    public Friend[] getAllSendingFriends() throws SkypeException {
        return this.getAllFriends("SENDING");
    }

    public Friend[] getAllReceivedFriends() throws SkypeException {
        return this.getAllFriends("RECEIVED");
    }

    private Friend[] getAllFriends(String type) throws SkypeException {
        try {
            String responseHeader = "APPLICATION " + this.getName() + " " + type + " ";
            String response = Connector.getInstance().executeWithId("GET APPLICATION " + this.getName() + " " + type, responseHeader);
            Utils.checkError(response);
            return this.extractFriends(response.substring(responseHeader.length()));
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    private Friend[] extractFriends(String list) throws SkypeException {
        String id;
        assert (list != null);
        if ("".equals(list)) {
            return new Friend[0];
        }
        String[] ids = list.split(" ");
        int i = 0;
        while (i < ids.length) {
            id = ids[i];
            if (id.contains(":")) {
                ids[i] = id.substring(0, id.indexOf(58));
            }
            ++i;
        }
        ArrayList<Friend> friends = new ArrayList<Friend>();
        String[] stringArray = ids;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            id = stringArray[n];
            Friend friend = Skype.getContactList().getFriend(id);
            if (!friends.contains(friend)) {
                friends.add(friend);
            }
            ++n;
        }
        return friends.toArray(new Friend[0]);
    }

    private class DataListener
    implements ConnectorListener {
        DataListener() {
        }

        public void messageReceived(String message) {
            String dataHeader = "APPLICATION " + Application.this.getName() + " ";
            if (this.isConnectedMessage(message)) {
                Friend friend;
                String streamId = message.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                int delimiterIndex = streamId.indexOf(58);
                String friendId = streamId.substring(0, delimiterIndex);
                try {
                    friend = Skype.getContactList().getFriend(friendId);
                }
                catch (SkypeException e) {
                    throw new IllegalStateException("can't get friend: friendId = " + friendId);
                }
                int number = Integer.parseInt(streamId.substring(delimiterIndex + 1));
                Stream stream = new Stream(Application.this, friend, number);
                Application.this.streams.put(streamId, stream);
                Application.this.fireConnected(stream);
            }
            if (message.startsWith(dataHeader)) {
                Application.this.handleData(message.substring(dataHeader.length()));
            }
        }

        private boolean isConnectedMessage(String message) {
            String header = "APPLICATION " + Application.this.getName() + " STREAMS ";
            return message.startsWith(header) && header.length() < message.length();
        }
    }
}

