/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.skype;

import java.util.Date;
import jp.sf.skype.Friend;
import jp.sf.skype.Skype;
import jp.sf.skype.SkypeException;
import jp.sf.skype.Utils;
import jp.sf.skype.connector.Connector;
import jp.sf.skype.connector.ConnectorException;

public final class Call {
    private final String id;

    Call(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void hold() throws SkypeException {
        this.setStatus("ONHOLD");
    }

    public void resume() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void finish() throws SkypeException {
        this.setStatus("FINISHED");
    }

    public void answer() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void cancel() throws SkypeException {
        this.setStatus("FINISHED");
    }

    private void setStatus(String status) throws SkypeException {
        try {
            String response = Connector.getInstance().execute("SET CALL " + this.getId() + " STATUS " + status, "CALL " + this.getId() + " STATUS ");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public Date getStartTime() throws SkypeException {
        return new Date(Long.parseLong(this.getProperty("TIMESTAMP")));
    }

    public Friend getParter() throws SkypeException {
        return Skype.getContactList().getFriend(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("STATUS"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getErrorCode() throws SkypeException {
        return Integer.parseInt(this.getProperty("FAILUREREASON"));
    }

    public void setReceiveVideoEnabled(boolean on) throws SkypeException {
        String value = on ? "START_VIDEO_SEND" : "STOP_VIDEO_SEND";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isReceiveVideoEnabled() throws SkypeException {
        VideoEnabled enabled = VideoEnabled.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_SEND_ENABLED: {
                return false;
            }
            case VIDEO_RECV_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public void setSendVideoEnabled(boolean on) throws SkypeException {
        String value = on ? "START_VIDEO_RECEIVE" : "STOP_VIDEO_RECEIVE";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isSendVideoEnabled() throws SkypeException {
        VideoEnabled enabled = VideoEnabled.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_RECV_ENABLED: {
                return false;
            }
            case VIDEO_SEND_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public VideoStatus getReceiveVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_RECEIVE_STATUS"));
    }

    public VideoStatus getSendVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_SEND_STATUS"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("CALL", this.getId(), name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNPLACED,
        ROUTING,
        EARLYMEDIA,
        FAILED,
        RINGING,
        INPROGRESS,
        ONHOLD,
        FINISHED,
        MISSED,
        REFUSED,
        BUSY,
        CANCELLED,
        VM_BUFFERING_GREETING,
        VM_PLAYING_GREETING,
        VM_RECORDING,
        VM_UPLOADING,
        VM_SENT,
        VM_CANCELLED,
        VM_FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMING_PSTN,
        OUTGOING_PSTN,
        INCOMING_P2P,
        OUTGOING_P2P;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VideoStatus {
        NOT_AVAILABLE,
        AVAILABLE,
        STARTING,
        REJECTED,
        RUNNING,
        STOPPING,
        PAUSED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VideoEnabled {
        VIDEO_NONE,
        VIDEO_SEND_ENABLED,
        VIDEO_RECV_ENABLED,
        VIDEO_BOTH_ENABLED;

    }
}

